/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.features.cache;

import io.ktor.client.HttpClient;
import io.ktor.client.call.HttpClientCall;
import io.ktor.client.features.HttpClientFeature;
import io.ktor.client.features.cache.CacheControl;
import io.ktor.client.features.cache.HttpCache;
import io.ktor.client.features.cache.HttpCacheEntry;
import io.ktor.client.features.cache.HttpCacheEntryKt;
import io.ktor.client.features.cache.HttpCacheKt;
import io.ktor.client.features.cache.InvalidCacheStateException;
import io.ktor.client.features.cache.storage.HttpCacheStorage;
import io.ktor.client.features.cache.storage.HttpCacheStorageKt;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpSendPipeline;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.statement.HttpReceivePipeline;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.AttributeKey;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0002J6\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lio/ktor/client/features/cache/HttpCache;", "", "publicStorage", "Lio/ktor/client/features/cache/storage/HttpCacheStorage;", "privateStorage", "(Lio/ktor/client/features/cache/storage/HttpCacheStorage;Lio/ktor/client/features/cache/storage/HttpCacheStorage;)V", "getPrivateStorage", "()Lio/ktor/client/features/cache/storage/HttpCacheStorage;", "getPublicStorage", "cacheResponse", "Lio/ktor/client/statement/HttpResponse;", "response", "(Lio/ktor/client/statement/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAndRefresh", "request", "Lio/ktor/client/request/HttpRequest;", "findResponse", "Lio/ktor/client/features/cache/HttpCacheEntry;", "storage", "varyKeys", "", "", "url", "Lio/ktor/http/Url;", "context", "Lio/ktor/client/request/HttpRequestBuilder;", "content", "Lio/ktor/http/content/OutgoingContent;", "Companion", "Config", "ktor-client-core"})
public final class HttpCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpCacheStorage publicStorage;
    @NotNull
    private final HttpCacheStorage privateStorage;
    @NotNull
    private static final AttributeKey<HttpCache> key = new AttributeKey("HttpCache");

    public HttpCache(@NotNull HttpCacheStorage publicStorage, @NotNull HttpCacheStorage privateStorage) {
        Intrinsics.checkNotNullParameter((Object)publicStorage, (String)"publicStorage");
        Intrinsics.checkNotNullParameter((Object)privateStorage, (String)"privateStorage");
        this.publicStorage = publicStorage;
        this.privateStorage = privateStorage;
    }

    @NotNull
    public final HttpCacheStorage getPublicStorage() {
        return this.publicStorage;
    }

    @NotNull
    public final HttpCacheStorage getPrivateStorage() {
        return this.privateStorage;
    }

    /*
     * Unable to fully structure code
     */
    private final Object cacheResponse(HttpResponse var1_1, Continuation<? super HttpResponse> var2_2) {
        if (!(var2_2 instanceof cacheResponse.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ HttpCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpCache.access$cacheResponse(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                request = response.getCall().getRequest();
                responseCacheControl = HttpMessagePropertiesKt.cacheControl((HttpMessage)response);
                v0 = storage = responseCacheControl.contains(CacheControl.INSTANCE.getPRIVATE$ktor_client_core()) != false ? this.getPrivateStorage() : this.getPublicStorage();
                if (responseCacheControl.contains(CacheControl.INSTANCE.getNO_STORE$ktor_client_core())) {
                    return response;
                }
                $continuation.label = 1;
                v1 = HttpCacheStorageKt.store(storage, request.getUrl(), (HttpResponse)response, (Continuation<? super HttpCacheEntry>)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl25:
                // 2 sources

                cacheEntry = (HttpCacheEntry)v1;
                return cacheEntry.produceResponse$ktor_client_core();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final HttpResponse findAndRefresh(HttpRequest request2, HttpResponse response2) {
        Url url2 = response2.getCall().getRequest().getUrl();
        List<HeaderValue> cacheControl = HttpMessagePropertiesKt.cacheControl(response2);
        HttpCacheStorage storage = cacheControl.contains(CacheControl.INSTANCE.getPRIVATE$ktor_client_core()) ? this.privateStorage : this.publicStorage;
        Map<String, String> varyKeysFrom304 = HttpCacheEntryKt.varyKeys(response2);
        HttpCacheEntry httpCacheEntry = this.findResponse(storage, varyKeysFrom304, url2, request2);
        if (httpCacheEntry == null) {
            return null;
        }
        HttpCacheEntry cache = httpCacheEntry;
        Map<String, String> map2 = varyKeysFrom304;
        Map<String, String> newVaryKeys = map2 == null || map2.isEmpty() ? cache.getVaryKeys() : varyKeysFrom304;
        storage.store(url2, new HttpCacheEntry(HttpCacheEntryKt.cacheExpires$default(response2, null, 1, null), newVaryKeys, cache.getResponse(), cache.getBody()));
        return cache.produceResponse$ktor_client_core();
    }

    /*
     * WARNING - void declaration
     */
    private final HttpCacheEntry findResponse(HttpCacheStorage storage, Map<String, String> varyKeys, Url url2, HttpRequest request2) {
        HttpCacheEntry httpCacheEntry;
        if (!varyKeys.isEmpty()) {
            httpCacheEntry = storage.find(url2, varyKeys);
        } else {
            Object v2;
            block7: {
                void $this$firstOrNull$iv;
                Iterable $this$sortedByDescending$iv;
                Function1 requestHeaders2 = HttpCacheKt.access$mergedHeadersLookup(request2.getContent(), (Function1)new Function1<String, String>((Object)request2.getHeaders()){

                    @Nullable
                    public final String invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((Headers)this.receiver).get(p0);
                    }
                }, (Function1)new Function1<String, List<? extends String>>((Object)request2.getHeaders()){

                    @Nullable
                    public final List<String> invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((Headers)this.receiver).getAll(p0);
                    }
                });
                Iterable iterable = storage.findByUrl(url2);
                boolean $i$f$sortedByDescending = false;
                $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HttpCacheEntry it = (HttpCacheEntry)b;
                        boolean bl = false;
                        Comparable comparable = it.getResponse().getResponseTime();
                        it = (HttpCacheEntry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getResponse().getResponseTime());
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    block6: {
                        HttpCacheEntry cachedResponse = (HttpCacheEntry)element$iv;
                        boolean bl2 = false;
                        Map<String, String> $this$all$iv = cachedResponse.getVaryKeys();
                        boolean $i$f$all = false;
                        if ($this$all$iv.isEmpty()) {
                            bl = true;
                        } else {
                            Iterator<Map.Entry<String, String>> iterator2 = $this$all$iv.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<String, String> element$iv2;
                                Map.Entry<String, String> $dstr$key$value = element$iv2 = iterator2.next();
                                boolean bl3 = false;
                                String key = $dstr$key$value.getKey();
                                String value = $dstr$key$value.getValue();
                                if (Intrinsics.areEqual((Object)requestHeaders2.invoke((Object)key), (Object)value)) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            httpCacheEntry = v2;
        }
        return httpCacheEntry;
    }

    private final HttpCacheEntry findResponse(HttpRequestBuilder context, OutgoingContent content2) {
        Url url2 = URLUtilsKt.Url(context.getUrl());
        Function1 lookup2 = HttpCacheKt.access$mergedHeadersLookup(content2, (Function1)new Function1<String, String>((Object)context.getHeaders()){

            @Nullable
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((HeadersBuilder)this.receiver).get(p0);
            }
        }, (Function1)new Function1<String, List<? extends String>>((Object)context.getHeaders()){

            @Nullable
            public final List<String> invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((HeadersBuilder)this.receiver).getAll(p0);
            }
        });
        Set cachedResponses = SetsKt.plus(this.privateStorage.findByUrl(url2), (Iterable)this.publicStorage.findByUrl(url2));
        for (HttpCacheEntry item : cachedResponses) {
            Map<String, String> varyKeys = item.getVaryKeys();
            if (!varyKeys.isEmpty()) {
                boolean bl;
                block5: {
                    Map<String, String> $this$all$iv = varyKeys;
                    boolean $i$f$all = false;
                    if ($this$all$iv.isEmpty()) {
                        bl = true;
                    } else {
                        Iterator<Map.Entry<String, String>> iterator2 = $this$all$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<String, String> element$iv;
                            Map.Entry<String, String> $dstr$key$value = element$iv = iterator2.next();
                            boolean bl2 = false;
                            String key = $dstr$key$value.getKey();
                            String value = $dstr$key$value.getValue();
                            if (Intrinsics.areEqual((Object)lookup2.invoke((Object)key), (Object)value)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
            }
            return item;
        }
        return null;
    }

    public static final /* synthetic */ HttpCacheEntry access$findResponse(HttpCache $this, HttpRequestBuilder context, OutgoingContent content2) {
        return $this.findResponse(context, content2);
    }

    public static final /* synthetic */ Object access$cacheResponse(HttpCache $this, HttpResponse response2, Continuation $completion) {
        return $this.cacheResponse(response2, (Continuation<? super HttpResponse>)$completion);
    }

    public static final /* synthetic */ HttpResponse access$findAndRefresh(HttpCache $this, HttpRequest request2, HttpResponse response2) {
        return $this.findAndRefresh(request2, response2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lio/ktor/client/features/cache/HttpCache$Config;", "", "()V", "privateStorage", "Lio/ktor/client/features/cache/storage/HttpCacheStorage;", "getPrivateStorage", "()Lio/ktor/client/features/cache/storage/HttpCacheStorage;", "setPrivateStorage", "(Lio/ktor/client/features/cache/storage/HttpCacheStorage;)V", "publicStorage", "getPublicStorage", "setPublicStorage", "ktor-client-core"})
    public static final class Config {
        @NotNull
        private HttpCacheStorage publicStorage = (HttpCacheStorage)HttpCacheStorage.Companion.getUnlimited().invoke();
        @NotNull
        private HttpCacheStorage privateStorage = (HttpCacheStorage)HttpCacheStorage.Companion.getUnlimited().invoke();

        @NotNull
        public final HttpCacheStorage getPublicStorage() {
            return this.publicStorage;
        }

        public final void setPublicStorage(@NotNull HttpCacheStorage httpCacheStorage) {
            Intrinsics.checkNotNullParameter((Object)httpCacheStorage, (String)"<set-?>");
            this.publicStorage = httpCacheStorage;
        }

        @NotNull
        public final HttpCacheStorage getPrivateStorage() {
            return this.privateStorage;
        }

        public final void setPrivateStorage(@NotNull HttpCacheStorage httpCacheStorage) {
            Intrinsics.checkNotNullParameter((Object)httpCacheStorage, (String)"<set-?>");
            this.privateStorage = httpCacheStorage;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J!\u0010\u000e\u001a\u00020\u00032\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u0010\u00a2\u0006\u0002\b\u0011H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/ktor/client/features/cache/HttpCache$Companion;", "Lio/ktor/client/features/HttpClientFeature;", "Lio/ktor/client/features/cache/HttpCache$Config;", "Lio/ktor/client/features/cache/HttpCache;", "()V", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "install", "", "feature", "scope", "Lio/ktor/client/HttpClient;", "prepare", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "ktor-client-core"})
    public static final class Companion
    implements HttpClientFeature<Config, HttpCache> {
        private Companion() {
        }

        @Override
        @NotNull
        public AttributeKey<HttpCache> getKey() {
            return key;
        }

        @Override
        @NotNull
        public HttpCache prepare(@NotNull Function1<? super Config, Unit> block2) {
            Config config2;
            Intrinsics.checkNotNullParameter(block2, (String)"block");
            Config config3 = new Config();
            block2.invoke((Object)config3);
            Config $this$prepare_u24lambda_u2d0 = config2 = config3;
            boolean bl = false;
            return new HttpCache($this$prepare_u24lambda_u2d0.getPublicStorage(), $this$prepare_u24lambda_u2d0.getPrivateStorage());
        }

        @Override
        public void install(@NotNull HttpCache feature, @NotNull HttpClient scope) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            PipelinePhase CachePhase = new PipelinePhase("Cache");
            scope.getSendPipeline().insertPhaseAfter(HttpSendPipeline.Phases.getState(), CachePhase);
            scope.getSendPipeline().intercept(CachePhase, (Function3)new Function3<PipelineContext<Object, HttpRequestBuilder>, Object, Continuation<? super Unit>, Object>(feature, null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;
                final /* synthetic */ HttpCache $feature;
                {
                    this.$feature = $feature;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    HttpCacheEntry cache;
                    PipelineContext $this$intercept;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            $this$intercept = (PipelineContext)this.L$0;
                            Object content2 = this.L$1;
                            if (!(content2 instanceof OutgoingContent.NoContent)) {
                                return Unit.INSTANCE;
                            }
                            if (!Intrinsics.areEqual((Object)((HttpRequestBuilder)$this$intercept.getContext()).getMethod(), (Object)HttpMethod.Companion.getGet()) || !HttpCacheKt.access$canStore(((HttpRequestBuilder)$this$intercept.getContext()).getUrl().getProtocol())) {
                                return Unit.INSTANCE;
                            }
                            HttpCacheEntry httpCacheEntry = HttpCache.access$findResponse(this.$feature, (HttpRequestBuilder)$this$intercept.getContext(), (OutgoingContent)content2);
                            if (httpCacheEntry == null) {
                                return Unit.INSTANCE;
                            }
                            cache = httpCacheEntry;
                            if (HttpCacheEntryKt.shouldValidate(cache)) break;
                            $this$intercept.finish();
                            this.L$0 = null;
                            this.label = 1;
                            Object object3 = $this$intercept.proceedWith(cache.produceResponse$ktor_client_core().getCall(), (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    String string = cache.getResponseHeaders$ktor_client_core().get(HttpHeaders.INSTANCE.getETag());
                    if (string != null) {
                        String etag = string;
                        boolean bl = false;
                        UtilsKt.header((HttpRequestBuilder)$this$intercept.getContext(), HttpHeaders.INSTANCE.getIfNoneMatch(), etag);
                    }
                    String string2 = cache.getResponseHeaders$ktor_client_core().get(HttpHeaders.INSTANCE.getLastModified());
                    if (string2 == null) return Unit.INSTANCE;
                    String it = string2;
                    boolean bl = false;
                    UtilsKt.header((HttpRequestBuilder)$this$intercept.getContext(), HttpHeaders.INSTANCE.getIfModifiedSince(), it);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<Object, HttpRequestBuilder> p1, @NotNull Object p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Object, HttpRequestBuilder>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
            scope.getReceivePipeline().intercept(HttpReceivePipeline.Phases.getState(), (Function3)new Function3<PipelineContext<HttpResponse, HttpClientCall>, HttpResponse, Continuation<? super Unit>, Object>(feature, null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;
                final /* synthetic */ HttpCache $feature;
                {
                    this.$feature = $feature;
                    super(3, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$intercept = (PipelineContext)this.L$0;
                            response = (HttpResponse)this.L$1;
                            if (!Intrinsics.areEqual((Object)((HttpClientCall)$this$intercept.getContext()).getRequest().getMethod(), (Object)HttpMethod.Companion.getGet())) {
                                return Unit.INSTANCE;
                            }
                            if (!HttpStatusCodeKt.isSuccess(response.getStatus())) break;
                            this.L$0 = $this$intercept;
                            this.label = 1;
                            v0 = HttpCache.access$cacheResponse(this.$feature, response, (Continuation)this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl20
                        }
                        case 1: {
                            $this$intercept = (PipelineContext)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl20:
                            // 2 sources

                            reusableResponse = (HttpResponse)v0;
                            this.L$0 = null;
                            this.label = 2;
                            v1 = $this$intercept.proceedWith(reusableResponse, (Continuation)this);
                            if (v1 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl30
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl30:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    if (Intrinsics.areEqual((Object)response.getStatus(), (Object)HttpStatusCode.Companion.getNotModified())) {
                        HttpResponseKt.complete(response);
                        var5_7 = HttpCache.access$findAndRefresh(this.$feature, ((HttpClientCall)$this$intercept.getContext()).getRequest(), response);
                        if (var5_7 == null) {
                            throw new InvalidCacheStateException(((HttpClientCall)$this$intercept.getContext()).getRequest().getUrl());
                        }
                        responseFromCache = var5_7;
                        this.L$0 = null;
                        this.label = 3;
                        v2 = $this$intercept.proceedWith(responseFromCache, (Continuation)this);
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                    }
                    ** GOTO lbl46
                    {
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl46:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<HttpResponse, HttpClientCall> p1, @NotNull HttpResponse p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<HttpResponse, HttpClientCall>, HttpResponse, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

