/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.InternalAPI;
import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\u001a\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0082\u0002\u001a \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0007\u001a\u001a\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0005H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0015H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"FirstReservedLetters", "", "ReservedCharacters", "ReservedWords", "", "", "contains", "", "char", "", "filterComponentsImpl", "", "startIndex", "", "normalizePathComponents", "processAndReplaceComponent", "", "", "component", "shouldBeReplaced", "toASCIITable", "", "ktor-server-core"})
public final class PathsKt {
    private static final boolean[] FirstReservedLetters = PathsKt.toASCIITable(new char[]{'A', 'a', 'C', 'c', 'l', 'L', 'P', 'p', 'n', 'N'});
    private static final Set<String> ReservedWords = SetsKt.setOf((Object[])new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"});
    private static final boolean[] ReservedCharacters = PathsKt.toASCIITable(new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'});

    /*
     * WARNING - void declaration
     */
    @InternalAPI
    @NotNull
    public static final List<String> normalizePathComponents(@NotNull List<String> $this$normalizePathComponents) {
        Intrinsics.checkNotNullParameter($this$normalizePathComponents, (String)"$this$normalizePathComponents");
        int n = 0;
        int n2 = ((Collection)$this$normalizePathComponents).size();
        while (n < n2) {
            void index;
            String component = $this$normalizePathComponents.get((int)index);
            if (PathsKt.shouldBeReplaced(component)) {
                return PathsKt.filterComponentsImpl($this$normalizePathComponents, (int)index);
            }
            ++index;
        }
        return $this$normalizePathComponents;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> filterComponentsImpl(List<String> $this$filterComponentsImpl, int startIndex) {
        ArrayList<String> result2 = new ArrayList<String>($this$filterComponentsImpl.size());
        if (startIndex > 0) {
            result2.addAll((Collection)$this$filterComponentsImpl.subList(0, startIndex));
        }
        PathsKt.processAndReplaceComponent((List<String>)result2, $this$filterComponentsImpl.get(startIndex));
        int n = startIndex + 1;
        int n2 = $this$filterComponentsImpl.size();
        while (n < n2) {
            void index;
            String component = $this$filterComponentsImpl.get((int)index);
            if (PathsKt.shouldBeReplaced(component)) {
                PathsKt.processAndReplaceComponent((List<String>)result2, component);
            } else {
                result2.add(component);
            }
            ++index;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void processAndReplaceComponent(List<String> $this$processAndReplaceComponent, String component) {
        block8: {
            CharSequence charSequence;
            int n;
            boolean bl;
            Object object;
            block7: {
                void $this$filterTo$iv$iv;
                object = component;
                bl = false;
                if (object.length() == 0 || Intrinsics.areEqual((Object)component, (Object)".") || Intrinsics.areEqual((Object)component, (Object)"~") || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules(component))) {
                    return;
                }
                if (Intrinsics.areEqual((Object)component, (Object)"..")) {
                    object = $this$processAndReplaceComponent;
                    bl = false;
                    if (!object.isEmpty()) {
                        $this$processAndReplaceComponent.remove(CollectionsKt.getLastIndex($this$processAndReplaceComponent));
                    }
                    return;
                }
                String $this$filter$iv = component;
                boolean $i$f$filter = false;
                CharSequence charSequence2 = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                int $i$f$filterTo = 0;
                int n2 = 0;
                n = $this$filterTo$iv$iv.length();
                while (n2 < n) {
                    void index$iv$iv;
                    char element$iv$iv;
                    char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
                    boolean bl2 = false;
                    if (Intrinsics.compare((int)it, (int)32) >= 0 && !PathsKt.contains(ReservedCharacters, it)) {
                        destination$iv$iv.append(element$iv$iv);
                    }
                    ++index$iv$iv;
                }
                String string = ((StringBuilder)destination$iv$iv).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
                String $this$trimEnd$iv = string;
                boolean $i$f$trimEnd = false;
                CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                boolean $i$f$trimEnd2 = false;
                $i$f$filterTo = $this$trimEnd$iv$iv.length();
                --$i$f$filterTo;
                n2 = 0;
                while ($i$f$filterTo >= 0) {
                    void index$iv$iv;
                    char it = $this$trimEnd$iv$iv.charAt((int)index$iv$iv);
                    boolean bl3 = false;
                    if (!(it == ' ' || it == '.')) {
                        charSequence = $this$trimEnd$iv$iv.subSequence(0, (int)(index$iv$iv + true));
                        break block7;
                    }
                    --index$iv$iv;
                }
                charSequence = "";
            }
            object = ((Object)charSequence).toString();
            bl = false;
            boolean bl4 = false;
            Object it = object;
            boolean bl5 = false;
            CharSequence charSequence3 = (CharSequence)it;
            n = 0;
            Object object2 = charSequence3.length() > 0 ? object : null;
            if (object2 == null) break block8;
            object = object2;
            bl = false;
            bl4 = false;
            Object filtered2 = object;
            boolean bl6 = false;
            $this$processAndReplaceComponent.add((String)filtered2);
        }
    }

    private static final boolean shouldBeReplaced(String $this$shouldBeReplaced) {
        boolean bl;
        block6: {
            int length = $this$shouldBeReplaced.length();
            if (length == 0) {
                return true;
            }
            char first = $this$shouldBeReplaced.charAt(0);
            if (first == '.' && (length == 1 || length == 2 && $this$shouldBeReplaced.charAt(1) == '.')) {
                return true;
            }
            if (first == '~' && length == 1) {
                return true;
            }
            if (PathsKt.contains(FirstReservedLetters, first) && (ReservedWords.contains($this$shouldBeReplaced) || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules($this$shouldBeReplaced)))) {
                return true;
            }
            char last = $this$shouldBeReplaced.charAt(length - 1);
            if (last == ' ' || last == '.') {
                return true;
            }
            boolean[] ReservedCharacters = PathsKt.ReservedCharacters;
            CharSequence $this$any$iv = $this$shouldBeReplaced;
            boolean $i$f$any = false;
            CharSequence charSequence = $this$any$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl2 = false;
                if (!(Intrinsics.compare((int)it, (int)32) < 0 || PathsKt.contains(ReservedCharacters, it))) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean[] toASCIITable(char[] $this$toASCIITable) {
        int n = 256;
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            void it;
            boolean bl;
            int n3 = n2;
            int n4 = n2++;
            boolean[] blArray2 = blArray;
            boolean bl2 = false;
            blArray2[n4] = bl = ArraysKt.contains((char[])$this$toASCIITable, (char)((char)it));
        }
        return blArray;
    }

    private static final boolean contains(boolean[] $this$contains, char c) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"$this$contains");
        char codepoint = c;
        return codepoint < $this$contains.length && $this$contains[codepoint];
    }
}

