/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.KtorExperimentalAPI;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0007\u001a\f\u0010\b\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\n\u0010\t\u001a\u00020\u0002*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\n"}, d2={"extension", "", "Ljava/nio/file/Path;", "getExtension", "(Ljava/nio/file/Path;)Ljava/lang/String;", "combineSafe", "Ljava/io/File;", "relativePath", "dropLeadingTopDirs", "normalizeAndRelativize", "ktor-utils"})
public final class NioPathKt {
    @NotNull
    public static final String getExtension(@NotNull Path $this$extension) {
        Intrinsics.checkNotNullParameter((Object)$this$extension, (String)"$this$extension");
        return StringsKt.substringAfterLast$default((String)((Object)$this$extension.getFileName()).toString(), (String)".", null, (int)2, null);
    }

    @KtorExperimentalAPI
    @NotNull
    public static final File combineSafe(@NotNull Path $this$combineSafe, @NotNull Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$combineSafe, (String)"$this$combineSafe");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw (Throwable)new InvalidPathException(((Object)relativePath).toString(), "Relative path " + relativePath + " beginning with .. is invalid");
        }
        boolean bl = !normalized.isAbsolute();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Bad relative path " + relativePath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        File file2 = $this$combineSafe.resolve(normalized).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"resolve(normalized).toFile()");
        return file2;
    }

    @NotNull
    public static final Path normalizeAndRelativize(@NotNull Path $this$normalizeAndRelativize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeAndRelativize, (String)"$this$normalizeAndRelativize");
        Path path2 = $this$normalizeAndRelativize.getRoot();
        if (path2 == null || (path2 = path2.relativize($this$normalizeAndRelativize)) == null || (path2 = path2.normalize()) == null || (path2 = NioPathKt.dropLeadingTopDirs(path2)) == null) {
            Path path3 = $this$normalizeAndRelativize.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"normalize()");
            path2 = NioPathKt.dropLeadingTopDirs(path3);
        }
        return path2;
    }

    private static final Path dropLeadingTopDirs(Path $this$dropLeadingTopDirs) {
        int startIndex;
        block4: {
            int n;
            Iterable $this$indexOfFirst$iv = $this$dropLeadingTopDirs;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                boolean bl = false;
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Path it = (Path)item$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)((Object)it).toString(), (Object)"..") ^ true) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = startIndex = -1;
        }
        if (startIndex == 0) {
            return $this$dropLeadingTopDirs;
        }
        Path path2 = $this$dropLeadingTopDirs.subpath(startIndex, $this$dropLeadingTopDirs.getNameCount());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"subpath(startIndex, nameCount)");
        return path2;
    }

    @KtorExperimentalAPI
    @NotNull
    public static final File combineSafe(@NotNull File $this$combineSafe, @NotNull Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$combineSafe, (String)"$this$combineSafe");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw (Throwable)new InvalidPathException(((Object)relativePath).toString(), "Relative path " + relativePath + " beginning with .. is invalid");
        }
        boolean bl = !normalized.isAbsolute();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Bad relative path " + relativePath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new File($this$combineSafe, ((Object)normalized).toString());
    }
}

