/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.DispatcherWithShutdown;
import io.ktor.util.DispatcherWithShutdown$WhenMappings;
import io.ktor.util.InternalAPI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;

@InternalAPI
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u0014\u001a\u00020\u000bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/ktor/util/DispatcherWithShutdown;", "Lkotlinx/coroutines/CoroutineDispatcher;", "delegate", "(Lkotlinx/coroutines/CoroutineDispatcher;)V", "shutdownPhase", "Lio/ktor/util/DispatcherWithShutdown$ShutdownPhase;", "shutdownPool", "Lkotlin/Lazy;", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "completeShutdown", "", "dispatch", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "isDispatchNeeded", "", "prepareShutdown", "ShutdownPhase", "ktor-server-core"})
public final class DispatcherWithShutdown
extends CoroutineDispatcher {
    private CoroutineDispatcher delegate;
    private volatile ShutdownPhase shutdownPhase;
    private final Lazy<ExecutorService> shutdownPool;

    public final void prepareShutdown() {
        this.shutdownPhase = ShutdownPhase.Graceful;
        this.delegate = null;
    }

    public final void completeShutdown() {
        this.shutdownPhase = ShutdownPhase.Completed;
        if (this.shutdownPool.isInitialized()) {
            ((ExecutorService)this.shutdownPool.getValue()).shutdown();
        }
    }

    public boolean isDispatchNeeded(@NotNull CoroutineContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        switch (DispatcherWithShutdown$WhenMappings.$EnumSwitchMapping$0[this.shutdownPhase.ordinal()]) {
            case 1: {
                CoroutineDispatcher coroutineDispatcher = this.delegate;
                if (coroutineDispatcher != null) {
                    bl = coroutineDispatcher.isDispatchNeeded(context);
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        switch (DispatcherWithShutdown$WhenMappings.$EnumSwitchMapping$1[this.shutdownPhase.ordinal()]) {
            case 1: {
                try {
                    CoroutineDispatcher coroutineDispatcher = this.delegate;
                    if (coroutineDispatcher == null) {
                        this.dispatch(context, block2);
                        return;
                    }
                    coroutineDispatcher.dispatch(context, block2);
                    break;
                }
                catch (RejectedExecutionException rejected) {
                    if (this.shutdownPhase != ShutdownPhase.None) {
                        this.dispatch(context, block2);
                        return;
                    }
                    throw (Throwable)rejected;
                }
            }
            case 2: {
                try {
                    ((ExecutorService)this.shutdownPool.getValue()).submit(block2);
                    break;
                }
                catch (RejectedExecutionException rejected) {
                    this.shutdownPhase = ShutdownPhase.Completed;
                    this.dispatch(context, block2);
                    return;
                }
            }
            case 3: {
                block2.run();
                break;
            }
        }
    }

    public DispatcherWithShutdown(@NotNull CoroutineDispatcher delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.shutdownPhase = ShutdownPhase.None;
        this.shutdownPool = LazyKt.lazy((Function0)shutdownPool.1.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/ktor/util/DispatcherWithShutdown$ShutdownPhase;", "", "(Ljava/lang/String;I)V", "None", "Graceful", "Completed", "ktor-server-core"})
    private static final class ShutdownPhase
    extends Enum<ShutdownPhase> {
        public static final /* enum */ ShutdownPhase None;
        public static final /* enum */ ShutdownPhase Graceful;
        public static final /* enum */ ShutdownPhase Completed;
        private static final /* synthetic */ ShutdownPhase[] $VALUES;

        static {
            ShutdownPhase[] shutdownPhaseArray = new ShutdownPhase[3];
            ShutdownPhase[] shutdownPhaseArray2 = shutdownPhaseArray;
            shutdownPhaseArray[0] = None = new ShutdownPhase();
            shutdownPhaseArray[1] = Graceful = new ShutdownPhase();
            shutdownPhaseArray[2] = Completed = new ShutdownPhase();
            $VALUES = shutdownPhaseArray;
        }

        public static ShutdownPhase[] values() {
            return (ShutdownPhase[])$VALUES.clone();
        }

        public static ShutdownPhase valueOf(String string) {
            return Enum.valueOf(ShutdownPhase.class, string);
        }
    }
}

