/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.sessions;

import io.ktor.sessions.SessionTransportTransformer;
import io.ktor.util.CryptoKt;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="This authentication kind is potentially vulnerable with several hash functions. Use SessionTransportTransformerMessageAuthentication instead or ensure you are using secure enough hash.", level=DeprecationLevel.ERROR)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lio/ktor/sessions/SessionTransportTransformerDigest;", "Lio/ktor/sessions/SessionTransportTransformer;", "salt", "", "algorithm", "(Ljava/lang/String;Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "getSalt", "digest", "", "value", "transformRead", "transportValue", "transformWrite", "ktor-server-core"})
public final class SessionTransportTransformerDigest
implements SessionTransportTransformer {
    @NotNull
    private final String salt;
    @NotNull
    private final String algorithm;

    @Override
    @Nullable
    public String transformRead(@NotNull String transportValue) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)transportValue, (String)"transportValue");
        String providedSignature = StringsKt.substringAfterLast((String)transportValue, (char)'/', (String)"");
        String value = StringsKt.substringBeforeLast$default((String)transportValue, (char)'/', null, (int)2, null);
        try {
            byArray = CryptoKt.hex(providedSignature);
        }
        catch (NumberFormatException e) {
            return null;
        }
        byte[] providedBytes = byArray;
        if (MessageDigest.isEqual(providedBytes, this.digest(value))) {
            return value;
        }
        return null;
    }

    @Override
    @NotNull
    public String transformWrite(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter((Object)transportValue, (String)"transportValue");
        return transportValue + '/' + CryptoKt.hex(this.digest(transportValue));
    }

    private final byte[] digest(String value) {
        MessageDigest md = MessageDigest.getInstance(this.algorithm);
        String string = this.salt;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        md.update(byArray);
        string = value;
        charset = Charsets.UTF_8;
        bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        md.update(byArray2);
        byte[] byArray3 = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"md.digest()");
        return byArray3;
    }

    @NotNull
    public final String getSalt() {
        return this.salt;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public SessionTransportTransformerDigest(@NotNull String salt, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.salt = salt;
        this.algorithm = algorithm;
    }

    public /* synthetic */ SessionTransportTransformerDigest(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "ktor";
        }
        if ((n & 2) != 0) {
            string2 = "SHA-384";
        }
        this(string, string2);
    }

    public SessionTransportTransformerDigest() {
        this(null, null, 3, null);
    }
}

