/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.request;

import io.ktor.features.OriginConnectionPointKt;
import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.RangesKt;
import io.ktor.http.RangesSpecifier;
import io.ktor.request.ApplicationRequest;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0012\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u0006*\u00020\u0002\u001a\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0006\u001a\n\u0010\u001f\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010 \u001a\u00020!*\u00020\u0002\u001a\n\u0010\"\u001a\u00020!*\u00020\u0002\u001a\f\u0010#\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\n\u0010$\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010%\u001a\u00020&*\u00020\u0002\u001a\n\u0010'\u001a\u00020\u0006*\u00020\u0002\u001a\f\u0010(\u001a\u0004\u0018\u00010)*\u00020\u0002\u001a\f\u0010*\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006+"}, d2={"httpMethod", "Lio/ktor/http/HttpMethod;", "Lio/ktor/request/ApplicationRequest;", "getHttpMethod", "(Lio/ktor/request/ApplicationRequest;)Lio/ktor/http/HttpMethod;", "httpVersion", "", "getHttpVersion", "(Lio/ktor/request/ApplicationRequest;)Ljava/lang/String;", "uri", "getUri", "accept", "acceptCharset", "acceptCharsetItems", "", "Lio/ktor/http/HeaderValue;", "acceptEncoding", "acceptEncodingItems", "acceptItems", "acceptLanguage", "acceptLanguageItems", "authorization", "cacheControl", "contentCharset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "contentType", "Lio/ktor/http/ContentType;", "document", "header", "name", "host", "isChunked", "", "isMultipart", "location", "path", "port", "", "queryString", "ranges", "Lio/ktor/http/RangesSpecifier;", "userAgent", "ktor-server-core"})
public final class ApplicationRequestPropertiesKt {
    @Nullable
    public static final String header(@NotNull ApplicationRequest $this$header, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$header, (String)"$this$header");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$header.getHeaders().get(name);
    }

    @NotNull
    public static final String queryString(@NotNull ApplicationRequest $this$queryString) {
        Intrinsics.checkNotNullParameter((Object)$this$queryString, (String)"$this$queryString");
        return StringsKt.substringAfter((String)OriginConnectionPointKt.getOrigin($this$queryString).getUri(), (char)'?', (String)"");
    }

    @NotNull
    public static final ContentType contentType(@NotNull ApplicationRequest $this$contentType) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"$this$contentType");
                object = ApplicationRequestPropertiesKt.header($this$contentType, HttpHeaders.INSTANCE.getContentType());
                if (object == null) break block2;
                String string = object;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                object = ContentType.Companion.parse(it);
                if (object != null) break block3;
            }
            object = ContentType.Companion.getAny();
        }
        return object;
    }

    @Nullable
    public static final Charset contentCharset(@NotNull ApplicationRequest $this$contentCharset) {
        Intrinsics.checkNotNullParameter((Object)$this$contentCharset, (String)"$this$contentCharset");
        return ContentTypesKt.charset(ApplicationRequestPropertiesKt.contentType($this$contentCharset));
    }

    @NotNull
    public static final String document(@NotNull ApplicationRequest $this$document) {
        Intrinsics.checkNotNullParameter((Object)$this$document, (String)"$this$document");
        return StringsKt.substringAfterLast$default((String)ApplicationRequestPropertiesKt.path($this$document), (char)'/', null, (int)2, null);
    }

    @NotNull
    public static final String path(@NotNull ApplicationRequest $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"$this$path");
        return StringsKt.substringBefore$default((String)OriginConnectionPointKt.getOrigin($this$path).getUri(), (char)'?', null, (int)2, null);
    }

    @Nullable
    public static final String authorization(@NotNull ApplicationRequest $this$authorization) {
        Intrinsics.checkNotNullParameter((Object)$this$authorization, (String)"$this$authorization");
        return ApplicationRequestPropertiesKt.header($this$authorization, HttpHeaders.INSTANCE.getAuthorization());
    }

    @Nullable
    public static final String location(@NotNull ApplicationRequest $this$location) {
        Intrinsics.checkNotNullParameter((Object)$this$location, (String)"$this$location");
        return ApplicationRequestPropertiesKt.header($this$location, HttpHeaders.INSTANCE.getLocation());
    }

    @Nullable
    public static final String accept(@NotNull ApplicationRequest $this$accept) {
        Intrinsics.checkNotNullParameter((Object)$this$accept, (String)"$this$accept");
        return ApplicationRequestPropertiesKt.header($this$accept, HttpHeaders.INSTANCE.getAccept());
    }

    @NotNull
    public static final List<HeaderValue> acceptItems(@NotNull ApplicationRequest $this$acceptItems) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptItems, (String)"$this$acceptItems");
        return HttpHeaderValueParserKt.parseAndSortContentTypeHeader(ApplicationRequestPropertiesKt.header($this$acceptItems, HttpHeaders.INSTANCE.getAccept()));
    }

    @Nullable
    public static final String acceptEncoding(@NotNull ApplicationRequest $this$acceptEncoding) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptEncoding, (String)"$this$acceptEncoding");
        return ApplicationRequestPropertiesKt.header($this$acceptEncoding, HttpHeaders.INSTANCE.getAcceptEncoding());
    }

    @NotNull
    public static final List<HeaderValue> acceptEncodingItems(@NotNull ApplicationRequest $this$acceptEncodingItems) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptEncodingItems, (String)"$this$acceptEncodingItems");
        return HttpHeaderValueParserKt.parseAndSortHeader(ApplicationRequestPropertiesKt.header($this$acceptEncodingItems, HttpHeaders.INSTANCE.getAcceptEncoding()));
    }

    @Nullable
    public static final String acceptLanguage(@NotNull ApplicationRequest $this$acceptLanguage) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptLanguage, (String)"$this$acceptLanguage");
        return ApplicationRequestPropertiesKt.header($this$acceptLanguage, HttpHeaders.INSTANCE.getAcceptLanguage());
    }

    @NotNull
    public static final List<HeaderValue> acceptLanguageItems(@NotNull ApplicationRequest $this$acceptLanguageItems) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptLanguageItems, (String)"$this$acceptLanguageItems");
        return HttpHeaderValueParserKt.parseAndSortHeader(ApplicationRequestPropertiesKt.header($this$acceptLanguageItems, HttpHeaders.INSTANCE.getAcceptLanguage()));
    }

    @Nullable
    public static final String acceptCharset(@NotNull ApplicationRequest $this$acceptCharset) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptCharset, (String)"$this$acceptCharset");
        return ApplicationRequestPropertiesKt.header($this$acceptCharset, HttpHeaders.INSTANCE.getAcceptCharset());
    }

    @NotNull
    public static final List<HeaderValue> acceptCharsetItems(@NotNull ApplicationRequest $this$acceptCharsetItems) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptCharsetItems, (String)"$this$acceptCharsetItems");
        return HttpHeaderValueParserKt.parseAndSortHeader(ApplicationRequestPropertiesKt.header($this$acceptCharsetItems, HttpHeaders.INSTANCE.getAcceptCharset()));
    }

    public static final boolean isChunked(@NotNull ApplicationRequest $this$isChunked) {
        Intrinsics.checkNotNullParameter((Object)$this$isChunked, (String)"$this$isChunked");
        String string = ApplicationRequestPropertiesKt.header($this$isChunked, HttpHeaders.INSTANCE.getTransferEncoding());
        return string != null && StringsKt.compareTo((String)string, (String)"chunked", (boolean)true) == 0;
    }

    public static final boolean isMultipart(@NotNull ApplicationRequest $this$isMultipart) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultipart, (String)"$this$isMultipart");
        return ApplicationRequestPropertiesKt.contentType($this$isMultipart).match(ContentType.MultiPart.INSTANCE.getAny());
    }

    @Nullable
    public static final String userAgent(@NotNull ApplicationRequest $this$userAgent) {
        Intrinsics.checkNotNullParameter((Object)$this$userAgent, (String)"$this$userAgent");
        return ApplicationRequestPropertiesKt.header($this$userAgent, HttpHeaders.INSTANCE.getUserAgent());
    }

    @Nullable
    public static final String cacheControl(@NotNull ApplicationRequest $this$cacheControl) {
        Intrinsics.checkNotNullParameter((Object)$this$cacheControl, (String)"$this$cacheControl");
        return ApplicationRequestPropertiesKt.header($this$cacheControl, HttpHeaders.INSTANCE.getCacheControl());
    }

    @NotNull
    public static final String host(@NotNull ApplicationRequest $this$host) {
        Intrinsics.checkNotNullParameter((Object)$this$host, (String)"$this$host");
        return OriginConnectionPointKt.getOrigin($this$host).getHost();
    }

    public static final int port(@NotNull ApplicationRequest $this$port) {
        Intrinsics.checkNotNullParameter((Object)$this$port, (String)"$this$port");
        return OriginConnectionPointKt.getOrigin($this$port).getPort();
    }

    @Nullable
    public static final RangesSpecifier ranges(@NotNull ApplicationRequest $this$ranges) {
        RangesSpecifier rangesSpecifier;
        Intrinsics.checkNotNullParameter((Object)$this$ranges, (String)"$this$ranges");
        String string = ApplicationRequestPropertiesKt.header($this$ranges, HttpHeaders.INSTANCE.getRange());
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String rangesSpec = string2;
            boolean bl3 = false;
            rangesSpecifier = RangesKt.parseRangesSpecifier(rangesSpec);
        } else {
            rangesSpecifier = null;
        }
        return rangesSpecifier;
    }

    @NotNull
    public static final String getUri(@NotNull ApplicationRequest $this$uri) {
        Intrinsics.checkNotNullParameter((Object)$this$uri, (String)"$this$uri");
        return OriginConnectionPointKt.getOrigin($this$uri).getUri();
    }

    @NotNull
    public static final HttpMethod getHttpMethod(@NotNull ApplicationRequest $this$httpMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$httpMethod, (String)"$this$httpMethod");
        return OriginConnectionPointKt.getOrigin($this$httpMethod).getMethod();
    }

    @NotNull
    public static final String getHttpVersion(@NotNull ApplicationRequest $this$httpVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$httpVersion, (String)"$this$httpVersion");
        return OriginConnectionPointKt.getOrigin($this$httpVersion).getVersion();
    }
}

