/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/network/sockets/SocketOptionsPlatformCapabilities;", "", "()V", "channelSetOption", "Ljava/lang/reflect/Method;", "datagramSetOption", "serverChannelSetOption", "standardSocketOptions", "", "", "Ljava/lang/reflect/Field;", "setReusePort", "", "channel", "Ljava/nio/channels/DatagramChannel;", "Ljava/nio/channels/ServerSocketChannel;", "Ljava/nio/channels/SocketChannel;", "socketOption", "name", "ktor-network"})
public final class SocketOptionsPlatformCapabilities {
    private static final Map<String, Field> standardSocketOptions;
    private static final Method channelSetOption;
    private static final Method serverChannelSetOption;
    private static final Method datagramSetOption;
    @NotNull
    public static final SocketOptionsPlatformCapabilities INSTANCE;

    public final void setReusePort(@NotNull SocketChannel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method2 = channelSetOption;
        Intrinsics.checkNotNull((Object)method2);
        method2.invoke((Object)channel2, option, true);
    }

    public final void setReusePort(@NotNull ServerSocketChannel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method2 = serverChannelSetOption;
        Intrinsics.checkNotNull((Object)method2);
        method2.invoke((Object)channel2, option, true);
    }

    public final void setReusePort(@NotNull DatagramChannel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method2 = datagramSetOption;
        Intrinsics.checkNotNull((Object)method2);
        method2.invoke((Object)channel2, option, true);
    }

    private final Object socketOption(String name) {
        Object object = standardSocketOptions.get(name);
        if (object == null || (object = ((Field)object).get(null)) == null) {
            throw (Throwable)new IOException("Socket option " + name + " is not supported");
        }
        return object;
    }

    private SocketOptionsPlatformCapabilities() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        Method method2;
        int modifiers;
        int n;
        Method method3;
        int n2;
        Method[] methodArray;
        Class<?> socketChannelClass;
        Class<?> socketOptionType;
        Object $this$associateBy$iv;
        boolean bl;
        int n3;
        SocketOptionsPlatformCapabilities socketOptionsPlatformCapabilities;
        INSTANCE = socketOptionsPlatformCapabilities = new SocketOptionsPlatformCapabilities();
        try {
            Map map;
            Field[] fieldArray = Class.forName("java.net.StandardSocketOptions");
            if (fieldArray != null && (fieldArray = fieldArray.getFields()) != null) {
                void $this$associateByTo$iv$iv;
                void $this$filterTo$iv$iv;
                Field[] $this$filter$iv = fieldArray;
                boolean $i$f$filter = false;
                Field[] fieldArray2 = $this$filter$iv;
                Object destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Field element$iv$iv2 : $this$filterTo$iv$iv) {
                    void it = element$iv$iv2;
                    boolean bl2 = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    n3 = v1.getModifiers();
                    bl = false;
                    boolean bl3 = false;
                    int modifiers2 = n3;
                    boolean bl4 = false;
                    boolean bl5 = Modifier.isStatic(modifiers2) && Modifier.isFinal(modifiers2) && Modifier.isPublic(modifiers2);
                    if (!bl5) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                $this$associateBy$iv = (List)destination$iv$iv;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    String string;
                    void it;
                    Field element$iv$iv2;
                    element$iv$iv2 = (Field)element$iv$iv;
                    Map map2 = destination$iv$iv2;
                    boolean bl6 = false;
                    void v3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                    Intrinsics.checkNotNullExpressionValue((Object)v3.getName(), (String)"it.name");
                    map2.put(string, element$iv$iv);
                }
                map = destination$iv$iv2;
            } else {
                map = MapsKt.emptyMap();
            }
            $this$associateBy$iv = map;
        }
        catch (Throwable _) {
            $this$associateBy$iv = MapsKt.emptyMap();
        }
        standardSocketOptions = $this$associateBy$iv;
        try {
            Method method4;
            block15: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(clazz);
                socketOptionType = clazz;
                Class<?> clazz2 = socketChannelClass = Class.forName("java.nio.channels.SocketChannel");
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"socketChannelClass");
                Method[] methodArray2 = clazz2.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray2, (String)"socketChannelClass.methods");
                Method[] $this$firstOrNull$iv = methodArray2;
                boolean $i$f$firstOrNull = false;
                methodArray = $this$firstOrNull$iv;
                n2 = methodArray.length;
                for (int i = 0; i < n2; ++i) {
                    Method element$iv;
                    method3 = element$iv = methodArray[i];
                    boolean bl7 = false;
                    Method method5 = method3;
                    Intrinsics.checkNotNullExpressionValue((Object)method5, (String)"method");
                    n = method5.getModifiers();
                    n3 = 0;
                    bl = false;
                    modifiers = n;
                    boolean bl8 = false;
                    if (!(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual((Object)method3.getName(), (Object)"setOption") && method3.getParameterTypes().length == 2 && Intrinsics.areEqual(method3.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method3.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method3.getParameterTypes()[1], Object.class))) continue;
                    method4 = element$iv;
                    break block15;
                }
                method4 = null;
            }
            socketOptionType = method4;
        }
        catch (Throwable _) {
            socketOptionType = null;
        }
        channelSetOption = socketOptionType;
        try {
            Method method6;
            block16: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(clazz);
                socketOptionType = clazz;
                Class<?> clazz3 = socketChannelClass = Class.forName("java.nio.channels.ServerSocketChannel");
                Intrinsics.checkNotNullExpressionValue(clazz3, (String)"socketChannelClass");
                Method[] methodArray3 = clazz3.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray3, (String)"socketChannelClass.methods");
                Method[] $this$firstOrNull$iv = methodArray3;
                boolean $i$f$firstOrNull = false;
                methodArray = $this$firstOrNull$iv;
                n2 = methodArray.length;
                for (int i = 0; i < n2; ++i) {
                    Method element$iv;
                    method3 = element$iv = methodArray[i];
                    boolean bl9 = false;
                    Method method7 = method3;
                    Intrinsics.checkNotNullExpressionValue((Object)method7, (String)"method");
                    n = method7.getModifiers();
                    n3 = 0;
                    bl = false;
                    modifiers = n;
                    boolean bl10 = false;
                    if (!(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual((Object)method3.getName(), (Object)"setOption") && method3.getParameterTypes().length == 2 && Intrinsics.areEqual(method3.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method3.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method3.getParameterTypes()[1], Object.class))) continue;
                    method6 = element$iv;
                    break block16;
                }
                method6 = null;
            }
            socketOptionType = method6;
        }
        catch (Throwable _) {
            socketOptionType = null;
        }
        serverChannelSetOption = socketOptionType;
        try {
            Method method8;
            block17: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(clazz);
                socketOptionType = clazz;
                Class<?> clazz4 = socketChannelClass = Class.forName("java.nio.channels.DatagramChannel");
                Intrinsics.checkNotNullExpressionValue(clazz4, (String)"socketChannelClass");
                Method[] methodArray4 = clazz4.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray4, (String)"socketChannelClass.methods");
                Method[] $this$firstOrNull$iv = methodArray4;
                boolean $i$f$firstOrNull = false;
                methodArray = $this$firstOrNull$iv;
                n2 = methodArray.length;
                for (int i = 0; i < n2; ++i) {
                    Method element$iv;
                    method3 = element$iv = methodArray[i];
                    boolean bl11 = false;
                    Method method9 = method3;
                    Intrinsics.checkNotNullExpressionValue((Object)method9, (String)"method");
                    n = method9.getModifiers();
                    n3 = 0;
                    bl = false;
                    modifiers = n;
                    boolean bl12 = false;
                    if (!(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual((Object)method3.getName(), (Object)"setOption") && method3.getParameterTypes().length == 2 && Intrinsics.areEqual(method3.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method3.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method3.getParameterTypes()[1], Object.class))) continue;
                    method8 = element$iv;
                    break block17;
                }
                method8 = null;
            }
            method2 = method8;
        }
        catch (Throwable _) {
            method2 = null;
        }
        datagramSetOption = method2;
    }
}

