/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.application.ApplicationCall;
import io.ktor.http.CodecsKt;
import io.ktor.http.ContentType;
import io.ktor.http.content.JarFileContent;
import io.ktor.http.content.LocalFileContent;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.StaticContentResolutionKt;
import io.ktor.http.content.URIFileContent;
import io.ktor.util.InternalAPI;
import io.ktor.util.PathsKt;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tH\u0007\u001a\f\u0010\u000b\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a@\u0010\f\u001a\u0004\u0018\u00010\u0005*\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u0011"}, d2={"findContainingJarFile", "Ljava/io/File;", "url", "", "resourceClasspathResource", "Lio/ktor/http/content/OutgoingContent;", "Ljava/net/URL;", "path", "mimeResolve", "Lkotlin/Function1;", "Lio/ktor/http/ContentType;", "extension", "resolveResource", "Lio/ktor/application/ApplicationCall;", "resourcePackage", "classLoader", "Ljava/lang/ClassLoader;", "ktor-server-core"})
public final class StaticContentResolutionKt {
    @Nullable
    public static final OutgoingContent resolveResource(@NotNull ApplicationCall $this$resolveResource, @NotNull String path2, @Nullable String resourcePackage, @NotNull ClassLoader classLoader, @NotNull Function1<? super String, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveResource, (String)"$this$resolveResource");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(mimeResolve, (String)"mimeResolve");
        if (StringsKt.endsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)"\\", (boolean)false, (int)2, null)) {
            return null;
        }
        String string = resourcePackage;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String normalizedPath = CollectionsKt.joinToString$default((Iterable)PathsKt.normalizePathComponents(CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)string2, (char[])new char[]{'.', '/', '\\'}, (boolean)false, (int)0, (int)6, null), (Iterable)StringsKt.split$default((CharSequence)path2, (char[])new char[]{'/', '\\'}, (boolean)false, (int)0, (int)6, null))), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        Enumeration<URL> enumeration = classLoader.getResources(normalizedPath);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"classLoader.getResources(normalizedPath)");
        Object object = enumeration;
        boolean bl2 = false;
        Iterator iterator2 = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(object)).iterator();
        while (iterator2.hasNext()) {
            URL url2;
            URL uRL = url2 = (URL)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"url");
            OutgoingContent outgoingContent = StaticContentResolutionKt.resourceClasspathResource(uRL, normalizedPath, mimeResolve);
            if (outgoingContent == null) continue;
            object = outgoingContent;
            bl2 = false;
            boolean bl3 = false;
            Object content2 = object;
            boolean bl4 = false;
            return content2;
        }
        return null;
    }

    public static /* synthetic */ OutgoingContent resolveResource$default(ApplicationCall applicationCall, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = applicationCall.getApplication().getEnvironment().getClassLoader();
        }
        if ((n & 8) != 0) {
            function1 = resolveResource.1.INSTANCE;
        }
        return StaticContentResolutionKt.resolveResource(applicationCall, string, string2, classLoader, (Function1<? super String, ContentType>)function1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalAPI
    @Nullable
    public static final OutgoingContent resourceClasspathResource(@NotNull URL url2, @NotNull String path2, @NotNull Function1<? super String, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(mimeResolve, (String)"mimeResolve");
        String string = url2.getProtocol();
        if (string == null) return null;
        switch (string) {
            case "file": {
                String string2 = url2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.path");
                File file2 = new File(CodecsKt.decodeURLPart$default(string2, 0, 0, null, 7, null));
                OutgoingContent outgoingContent = file2.isFile() ? new LocalFileContent(file2, (ContentType)mimeResolve.invoke((Object)FilesKt.getExtension((File)file2))) : null;
                return outgoingContent;
            }
            case "jar": {
                JarFileContent jarFileContent;
                if (StringsKt.endsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null)) {
                    jarFileContent = null;
                } else {
                    String string3 = url2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"url.toString()");
                    File zipFile = StaticContentResolutionKt.findContainingJarFile(string3);
                    String string4 = url2.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"url.path");
                    JarFileContent content2 = new JarFileContent(zipFile, path2, (ContentType)mimeResolve.invoke((Object)StaticContentResolutionKt.extension(string4)));
                    jarFileContent = content2.isFile() ? content2 : null;
                }
                OutgoingContent outgoingContent = jarFileContent;
                return outgoingContent;
            }
            case "jrt": {
                String string5 = url2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"url.path");
                OutgoingContent outgoingContent = new URIFileContent(url2, (ContentType)mimeResolve.invoke((Object)StaticContentResolutionKt.extension(string5)));
                return outgoingContent;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public static final File findContainingJarFile(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        if (StringsKt.startsWith$default((String)url2, (String)"jar:file:", (boolean)false, (int)2, null)) {
            int jarPathSeparator = StringsKt.indexOf$default((CharSequence)url2, (String)"!", (int)9, (boolean)false, (int)4, null);
            boolean bl = jarPathSeparator != -1;
            int n = 0;
            boolean bl2 = false;
            if (!bl) {
                boolean bl3 = false;
                String string = "Jar path requires !/ separator but it is: " + url2;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String string = url2;
            n = 9;
            bl2 = false;
            String string2 = string.substring(n, jarPathSeparator);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return new File(CodecsKt.decodeURLPart$default(string2, 0, 0, null, 7, null));
        }
        throw (Throwable)new IllegalArgumentException("Only local jars are supported (jar:file:)");
    }

    private static final String extension(String $this$extension) {
        String string;
        Integer n = StringsKt.lastIndexOf$default((CharSequence)$this$extension, (char)'/', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = it != -1 ? n : null;
        if (n2 == null) {
            n = StringsKt.lastIndexOf$default((CharSequence)$this$extension, (char)'\\', (int)0, (boolean)false, (int)6, null);
            bl = false;
            bl2 = false;
            it = ((Number)n).intValue();
            boolean bl4 = false;
            n2 = it != -1 ? n : null;
        }
        int indexOfName = n2 != null ? n2 : 0;
        int indexOfDot = StringsKt.indexOf$default((CharSequence)$this$extension, (char)'.', (int)indexOfName, (boolean)false, (int)4, null);
        if (indexOfDot >= 0) {
            String string2 = $this$extension;
            bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(indexOfDot);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = "";
        }
        return string;
    }
}

