/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.content.LastModifiedJavaTimeKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.VersionsKt;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.jvm.javaio.ReadingKt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010'\u001a\u00020(H\u0016R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0012\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR#\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0016\u001a\u0004\b\u001f\u0010 R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lio/ktor/http/content/JarFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "zipFilePath", "Ljava/nio/file/Path;", "resourcePath", "", "contentType", "Lio/ktor/http/ContentType;", "(Ljava/nio/file/Path;Ljava/lang/String;Lio/ktor/http/ContentType;)V", "jarFile", "Ljava/io/File;", "(Ljava/io/File;Ljava/lang/String;Lio/ktor/http/ContentType;)V", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getContentType", "()Lio/ktor/http/ContentType;", "isFile", "", "()Z", "isFile$delegate", "Lkotlin/Lazy;", "jar", "Ljava/util/jar/JarFile;", "getJar", "()Ljava/util/jar/JarFile;", "jar$delegate", "jarEntry", "Ljava/util/jar/JarEntry;", "kotlin.jvm.PlatformType", "getJarEntry", "()Ljava/util/jar/JarEntry;", "jarEntry$delegate", "getJarFile", "()Ljava/io/File;", "normalized", "getResourcePath", "()Ljava/lang/String;", "readFrom", "Lio/ktor/utils/io/ByteReadChannel;", "ktor-server-core"})
public final class JarFileContent
extends OutgoingContent.ReadChannelContent {
    private final String normalized;
    private final Lazy jarEntry$delegate;
    private final Lazy jar$delegate;
    @NotNull
    private final Lazy isFile$delegate;
    @NotNull
    private final File jarFile;
    @NotNull
    private final String resourcePath;
    @NotNull
    private final ContentType contentType;

    private final JarEntry getJarEntry() {
        Lazy lazy = this.jarEntry$delegate;
        JarFileContent jarFileContent = this;
        Object var3_3 = null;
        boolean bl = false;
        return (JarEntry)lazy.getValue();
    }

    private final JarFile getJar() {
        Lazy lazy = this.jar$delegate;
        JarFileContent jarFileContent = this;
        Object var3_3 = null;
        boolean bl = false;
        return (JarFile)lazy.getValue();
    }

    public final boolean isFile() {
        Lazy lazy = this.isFile$delegate;
        JarFileContent jarFileContent = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Override
    @Nullable
    public Long getContentLength() {
        JarEntry jarEntry2 = this.getJarEntry();
        return jarEntry2 != null ? Long.valueOf(jarEntry2.getSize()) : null;
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        Object object = this.getJar().getInputStream(this.getJarEntry());
        if (object == null || (object = ReadingKt.toByteReadChannel$default((InputStream)object, null, ByteBufferPoolKt.getKtorDefaultPool(), 1, null)) == null) {
            throw (Throwable)new IOException("Resource " + this.normalized + " not found");
        }
        return object;
    }

    @NotNull
    public final File getJarFile() {
        return this.jarFile;
    }

    @NotNull
    public final String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    public JarFileContent(@NotNull File jarFile, @NotNull String resourcePath, @NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        this.jarFile = jarFile;
        this.resourcePath = resourcePath;
        this.contentType = contentType2;
        this.normalized = StringsKt.replace$default((String)((Object)Paths.get(this.resourcePath, new String[0]).normalize()).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        this.jarEntry$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JarEntry>(this){
            final /* synthetic */ JarFileContent this$0;

            public final JarEntry invoke() {
                return JarFileContent.access$getJar$p(this.this$0).getJarEntry(this.this$0.getResourcePath());
            }
            {
                this.this$0 = jarFileContent;
                super(0);
            }
        }));
        this.jar$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JarFile>(this){
            final /* synthetic */ JarFileContent this$0;

            @NotNull
            public final JarFile invoke() {
                return new JarFile(this.this$0.getJarFile());
            }
            {
                this.this$0 = jarFileContent;
                super(0);
            }
        }));
        this.isFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ JarFileContent this$0;

            public final boolean invoke() {
                JarEntry jarEntry2 = JarFileContent.access$getJarEntry$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)jarEntry2, (String)"jarEntry");
                return !jarEntry2.isDirectory();
            }
            {
                this.this$0 = jarFileContent;
                super(0);
            }
        }));
        boolean bl = !StringsKt.startsWith$default((String)this.normalized, (String)"..", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Bad resource relative path " + this.resourcePath;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        JarFileContent jarFileContent = this;
        Collection collection = VersionsKt.getVersions(jarFileContent);
        JarEntry jarEntry2 = this.getJarEntry();
        Intrinsics.checkNotNullExpressionValue((Object)jarEntry2, (String)"jarEntry");
        FileTime fileTime = jarEntry2.getLastModifiedTime();
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"jarEntry.lastModifiedTime");
        VersionsKt.setVersions(jarFileContent, CollectionsKt.plus((Collection)collection, (Object)LastModifiedJavaTimeKt.LastModifiedVersion(fileTime)));
    }

    public JarFileContent(@NotNull Path zipFilePath, @NotNull String resourcePath, @NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        File file2 = zipFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"zipFilePath.toFile()");
        this(file2, resourcePath, contentType2);
    }

    public static final /* synthetic */ JarFile access$getJar$p(JarFileContent $this) {
        return $this.getJar();
    }

    public static final /* synthetic */ JarEntry access$getJarEntry$p(JarFileContent $this) {
        return $this.getJarEntry();
    }
}

