/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.HttpUrlEncodedKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserKt;
import io.ktor.http.Url;
import io.ktor.util.StringValuesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b\u001a\u000e\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0001\u001a(\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a(\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0012\u0010\u0017\u001a\u00020\b*\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a\u0012\u0010\u0017\u001a\u00020\b*\u00020\b2\u0006\u0010\n\u001a\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0018"}, d2={"fullPath", "", "Lio/ktor/http/Url;", "getFullPath", "(Lio/ktor/http/Url;)Ljava/lang/String;", "hostWithPort", "getHostWithPort", "URLBuilder", "Lio/ktor/http/URLBuilder;", "builder", "url", "urlString", "Url", "appendUrlFullPath", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "encodedPath", "queryParameters", "Lio/ktor/http/Parameters;", "trailingQuery", "", "Lio/ktor/http/ParametersBuilder;", "takeFrom", "ktor-http"})
public final class URLUtilsKt {
    @NotNull
    public static final Url Url(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        return URLUtilsKt.URLBuilder(urlString).build();
    }

    @NotNull
    public static final Url Url(@NotNull URLBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), builder).build();
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        return URLParserKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), urlString);
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull Url url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), url2);
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull URLBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), builder);
    }

    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull URLBuilder url2) {
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"$this$takeFrom");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        $this$takeFrom.setProtocol(url2.getProtocol());
        $this$takeFrom.setHost(url2.getHost());
        $this$takeFrom.setPort(url2.getPort());
        $this$takeFrom.setEncodedPath(url2.getEncodedPath());
        $this$takeFrom.setUser(url2.getUser());
        $this$takeFrom.setPassword(url2.getPassword());
        StringValuesKt.appendAll($this$takeFrom.getParameters(), url2.getParameters());
        $this$takeFrom.setFragment(url2.getFragment());
        $this$takeFrom.setTrailingQuery(url2.getTrailingQuery());
        return $this$takeFrom;
    }

    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull Url url2) {
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"$this$takeFrom");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        $this$takeFrom.setProtocol(url2.getProtocol());
        $this$takeFrom.setHost(url2.getHost());
        $this$takeFrom.setPort(url2.getSpecifiedPort());
        $this$takeFrom.setEncodedPath(url2.getEncodedPath());
        $this$takeFrom.setUser(url2.getUser());
        $this$takeFrom.setPassword(url2.getPassword());
        $this$takeFrom.getParameters().appendAll(url2.getParameters());
        $this$takeFrom.setFragment(url2.getFragment());
        $this$takeFrom.setTrailingQuery(url2.getTrailingQuery());
        return $this$takeFrom;
    }

    @NotNull
    public static final String getFullPath(@NotNull Url $this$fullPath) {
        Intrinsics.checkNotNullParameter((Object)$this$fullPath, (String)"$this$fullPath");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        URLUtilsKt.appendUrlFullPath((Appendable)$this$buildString, $this$fullPath.getEncodedPath(), $this$fullPath.getParameters(), $this$fullPath.getTrailingQuery());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String getHostWithPort(@NotNull Url $this$hostWithPort) {
        Intrinsics.checkNotNullParameter((Object)$this$hostWithPort, (String)"$this$hostWithPort");
        return $this$hostWithPort.getHost() + ':' + $this$hostWithPort.getPort();
    }

    public static final void appendUrlFullPath(@NotNull Appendable $this$appendUrlFullPath, @NotNull String encodedPath, @NotNull Parameters queryParameters2, boolean trailingQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$appendUrlFullPath, (String)"$this$appendUrlFullPath");
        Intrinsics.checkNotNullParameter((Object)encodedPath, (String)"encodedPath");
        Intrinsics.checkNotNullParameter((Object)queryParameters2, (String)"queryParameters");
        CharSequence charSequence = encodedPath;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence) && !StringsKt.startsWith$default((String)encodedPath, (String)"/", (boolean)false, (int)2, null)) {
            $this$appendUrlFullPath.append('/');
        }
        $this$appendUrlFullPath.append(encodedPath);
        if (!queryParameters2.isEmpty() || trailingQuery) {
            $this$appendUrlFullPath.append("?");
        }
        HttpUrlEncodedKt.formUrlEncodeTo(queryParameters2, $this$appendUrlFullPath);
    }

    public static final void appendUrlFullPath(@NotNull Appendable $this$appendUrlFullPath, @NotNull String encodedPath, @NotNull ParametersBuilder queryParameters2, boolean trailingQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$appendUrlFullPath, (String)"$this$appendUrlFullPath");
        Intrinsics.checkNotNullParameter((Object)encodedPath, (String)"encodedPath");
        Intrinsics.checkNotNullParameter((Object)queryParameters2, (String)"queryParameters");
        CharSequence charSequence = encodedPath;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence) && !StringsKt.startsWith$default((String)encodedPath, (String)"/", (boolean)false, (int)2, null)) {
            $this$appendUrlFullPath.append('/');
        }
        $this$appendUrlFullPath.append(encodedPath);
        if (!queryParameters2.isEmpty() || trailingQuery) {
            $this$appendUrlFullPath.append("?");
        }
        HttpUrlEncodedKt.formUrlEncodeTo(queryParameters2, $this$appendUrlFullPath);
    }
}

