/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.features;

import io.ktor.application.ApplicationCall;
import io.ktor.features.Compression;
import io.ktor.features.CompressionEncoderBuilder;
import io.ktor.features.CompressionKt;
import io.ktor.features.ConditionsHolderBuilder;
import io.ktor.features.DeflateEncoder;
import io.ktor.features.GzipEncoder;
import io.ktor.features.IdentityEncoder;
import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.OutgoingContent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\u001a)\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u001d\u0010\u0005\u001a\u0019\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\b\n\u001a\f\u0010\u000b\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a%\u0010\f\u001a\u00020\u0003*\u00020\r2\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\b\n\u001a#\u0010\u0011\u001a\u00020\u0003*\u00020\u00042\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014\u00a2\u0006\u0002\u0010\u0015\u001a%\u0010\u0016\u001a\u00020\u0003*\u00020\r2\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\b\n\u001a%\u0010\u0017\u001a\u00020\u0003*\u00020\r2\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\b\n\u001a\f\u0010\u0018\u001a\u00020\t*\u00020\u0007H\u0002\u001a#\u0010\u0019\u001a\u00020\u0003*\u00020\u00042\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014\u00a2\u0006\u0002\u0010\u0015\u001a\u0012\u0010\u001a\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"DEFAULT_MINIMAL_COMPRESSION_SIZE", "", "condition", "", "Lio/ktor/features/ConditionsHolderBuilder;", "predicate", "Lkotlin/Function2;", "Lio/ktor/application/ApplicationCall;", "Lio/ktor/http/content/OutgoingContent;", "", "Lkotlin/ExtensionFunctionType;", "defaultConditions", "deflate", "Lio/ktor/features/Compression$Configuration;", "block", "Lkotlin/Function1;", "Lio/ktor/features/CompressionEncoderBuilder;", "excludeContentType", "mimeTypes", "", "Lio/ktor/http/ContentType;", "(Lio/ktor/features/ConditionsHolderBuilder;[Lio/ktor/http/ContentType;)V", "gzip", "identity", "isCompressionSuppressed", "matchContentType", "minimumSize", "minSize", "ktor-server-core"})
public final class CompressionKt {
    public static final long DEFAULT_MINIMAL_COMPRESSION_SIZE = 200L;

    private static final boolean isCompressionSuppressed(ApplicationCall $this$isCompressionSuppressed) {
        return $this$isCompressionSuppressed.getAttributes().contains(Compression.Feature.getSuppressionAttribute());
    }

    public static final void gzip(@NotNull Compression.Configuration $this$gzip, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$gzip, (String)"$this$gzip");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        $this$gzip.encoder("gzip", GzipEncoder.INSTANCE, block2);
    }

    public static /* synthetic */ void gzip$default(Compression.Configuration configuration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = gzip.1.INSTANCE;
        }
        CompressionKt.gzip(configuration, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void deflate(@NotNull Compression.Configuration $this$deflate, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$deflate, (String)"$this$deflate");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        $this$deflate.encoder("deflate", DeflateEncoder.INSTANCE, (Function1<? super CompressionEncoderBuilder, Unit>)((Function1)new Function1<CompressionEncoderBuilder, Unit>(block2){
            final /* synthetic */ Function1 $block;

            public final void invoke(@NotNull CompressionEncoderBuilder $this$encoder) {
                Intrinsics.checkNotNullParameter((Object)$this$encoder, (String)"$receiver");
                $this$encoder.setPriority(0.9);
                this.$block.invoke((Object)$this$encoder);
            }
            {
                this.$block = function1;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void deflate$default(Compression.Configuration configuration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = deflate.1.INSTANCE;
        }
        CompressionKt.deflate(configuration, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void identity(@NotNull Compression.Configuration $this$identity, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$identity, (String)"$this$identity");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        $this$identity.encoder("identity", IdentityEncoder.INSTANCE, block2);
    }

    public static /* synthetic */ void identity$default(Compression.Configuration configuration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = identity.1.INSTANCE;
        }
        CompressionKt.identity(configuration, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void condition(@NotNull ConditionsHolderBuilder $this$condition, @NotNull Function2<? super ApplicationCall, ? super OutgoingContent, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        $this$condition.getConditions().add(predicate);
    }

    public static final void minimumSize(@NotNull ConditionsHolderBuilder $this$minimumSize, long minSize) {
        Intrinsics.checkNotNullParameter((Object)$this$minimumSize, (String)"$this$minimumSize");
        CompressionKt.condition($this$minimumSize, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(minSize){
            final /* synthetic */ long $minSize;

            public final boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$receiver");
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                Long l = content2.getContentLength();
                if (l != null) {
                    Long l2 = l;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    long it = ((Number)l2).longValue();
                    boolean bl4 = false;
                    bl = it >= this.$minSize;
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$minSize = l;
                super(2);
            }
        }));
    }

    public static final void matchContentType(@NotNull ConditionsHolderBuilder $this$matchContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$matchContentType, (String)"$this$matchContentType");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        CompressionKt.condition($this$matchContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;

            public final boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content2) {
                boolean bl;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$receiver");
                    Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                    ContentType contentType2 = content2.getContentType();
                    if (contentType2 == null) {
                        return false;
                    }
                    ContentType contentType3 = contentType2;
                    ContentType[] $this$any$iv = this.$mimeTypes;
                    boolean $i$f$any = false;
                    ContentType[] contentTypeArray = $this$any$iv;
                    int n = contentTypeArray.length;
                    for (int i = 0; i < n; ++i) {
                        ContentType element$iv;
                        ContentType it = element$iv = contentTypeArray[i];
                        boolean bl2 = false;
                        if (!contentType3.match(it)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$mimeTypes = contentTypeArray;
                super(2);
            }
        }));
    }

    public static final void excludeContentType(@NotNull ConditionsHolderBuilder $this$excludeContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$excludeContentType, (String)"$this$excludeContentType");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        CompressionKt.condition($this$excludeContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;

            public final boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content2) {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$receiver");
                    Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                    ContentType contentType2 = content2.getContentType();
                    if (contentType2 == null) {
                        String string = $this$condition.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getContentType());
                        if (string != null) {
                            String string2 = string;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            String it = string2;
                            boolean bl4 = false;
                            contentType2 = ContentType.Companion.parse(it);
                        } else {
                            contentType2 = null;
                        }
                    }
                    if (contentType2 == null) {
                        return true;
                    }
                    ContentType contentType3 = contentType2;
                    ContentType[] $this$none$iv = this.$mimeTypes;
                    boolean $i$f$none = false;
                    ContentType[] contentTypeArray = $this$none$iv;
                    int n = contentTypeArray.length;
                    for (int i = 0; i < n; ++i) {
                        ContentType element$iv;
                        ContentType excludePattern = element$iv = contentTypeArray[i];
                        boolean bl5 = false;
                        if (!contentType3.match(excludePattern)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                return bl;
            }
            {
                this.$mimeTypes = contentTypeArray;
                super(2);
            }
        }));
    }

    private static final void defaultConditions(ConditionsHolderBuilder $this$defaultConditions) {
        CompressionKt.excludeContentType($this$defaultConditions, ContentType.Video.INSTANCE.getAny(), ContentType.Image.INSTANCE.getJPEG(), ContentType.Image.INSTANCE.getPNG(), ContentType.Audio.INSTANCE.getAny(), ContentType.MultiPart.INSTANCE.getAny(), ContentType.Text.INSTANCE.getEventStream());
        CompressionKt.minimumSize($this$defaultConditions, 200L);
    }

    public static final /* synthetic */ void access$defaultConditions(ConditionsHolderBuilder $this$access_u24defaultConditions) {
        CompressionKt.defaultConditions($this$access_u24defaultConditions);
    }

    public static final /* synthetic */ boolean access$isCompressionSuppressed(ApplicationCall $this$access_u24isCompressionSuppressed) {
        return CompressionKt.isCompressionSuppressed($this$access_u24isCompressionSuppressed);
    }
}

