/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.api.http.context.session.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.api.http.context.MahContext;
import net.mamoe.mirai.api.http.context.cache.MessageSourceCache;
import net.mamoe.mirai.api.http.context.session.ListenableSessionWrapper;
import net.mamoe.mirai.api.http.context.session.Session;
import net.mamoe.mirai.api.http.context.session.StandardSession;
import net.mamoe.mirai.api.http.context.session.manager.SessionManager;
import net.mamoe.mirai.api.http.context.session.manager.UtilKt;
import net.mamoe.mirai.api.http.setting.MainSetting;
import net.mamoe.mirai.event.events.BotEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\tH\u0016J\u0019\u0010!\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000eH\u0096\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lnet/mamoe/mirai/api/http/context/session/manager/DefaultSessionManager;", "Lnet/mamoe/mirai/api/http/context/session/manager/SessionManager;", "verifyKey", "", "context", "Lnet/mamoe/mirai/api/http/context/MahContext;", "(Ljava/lang/String;Lnet/mamoe/mirai/api/http/context/MahContext;)V", "cacheMap", "", "", "Lnet/mamoe/mirai/api/http/context/cache/MessageSourceCache;", "getContext", "()Lnet/mamoe/mirai/api/http/context/MahContext;", "sessionMap", "Lnet/mamoe/mirai/api/http/context/session/Session;", "getVerifyKey", "()Ljava/lang/String;", "authSession", "bot", "Lnet/mamoe/mirai/Bot;", "tempSessionKey", "authedSessions", "", "close", "", "closeSession", "key", "createOneTimeSession", "Lnet/mamoe/mirai/api/http/context/session/StandardSession;", "createTempSession", "get", "getCache", "id", "set", "session", "mirai-api-http"})
public final class DefaultSessionManager
implements SessionManager {
    private final Map<String, Session> sessionMap;
    private final Map<Long, MessageSourceCache> cacheMap;
    @NotNull
    private final String verifyKey;
    @NotNull
    private final MahContext context;

    @Override
    @NotNull
    public StandardSession createOneTimeSession(@NotNull Bot bot) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        StandardSession standardSession = new StandardSession("", this);
        boolean bl = false;
        boolean bl2 = false;
        StandardSession oneTimeSession = standardSession;
        boolean bl3 = false;
        oneTimeSession.authWith(bot, this.getCache(bot.getId()));
        return standardSession;
    }

    @Override
    @NotNull
    public Session createTempSession() {
        return this.createTempSession(UtilKt.generateSessionKey(this));
    }

    @Override
    @NotNull
    public Session createTempSession(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StandardSession standardSession = new StandardSession(key, this);
        boolean bl = false;
        boolean bl2 = false;
        StandardSession newTempSession = standardSession;
        boolean bl3 = false;
        ListenableSessionWrapper proxy = new ListenableSessionWrapper(newTempSession);
        ListenableSessionWrapper.startExpiredCountdown$default(proxy, 180000L, null, 2, null);
        this.sessionMap.put(newTempSession.getKey(), proxy);
        return standardSession;
    }

    @Override
    @NotNull
    public Session authSession(@NotNull Bot bot, @NotNull String tempSessionKey) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)tempSessionKey, (String)"tempSessionKey");
        Session session = this.get(tempSessionKey);
        if (session == null) {
            throw (Throwable)new NoSuchElementException();
        }
        Session session2 = session;
        if (session2.isAuthed()) {
            return session2;
        }
        session2.ref();
        session2.putExtElement(ListenableSessionWrapper.Key.getBotEventHandler(), new Function2<Session, BotEvent, Unit>(this.context){

            public final void invoke(@NotNull Session p1, @NotNull BotEvent p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                ((MahContext)this.receiver).handleBotEvent(p1, p2);
            }
        });
        session2.authWith(bot, this.getCache(bot.getId()));
        return session2;
    }

    @Override
    @Nullable
    public Session get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sessionMap.get(key);
    }

    @Override
    public void set(@NotNull String key, @NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.sessionMap.put(key, session);
    }

    @Override
    public void closeSession(@NotNull String key) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Session session = this.sessionMap.get(key);
            if (session == null) break block1;
            Session session2 = session;
            boolean bl = false;
            boolean bl2 = false;
            Session $this$apply = session2;
            boolean bl3 = false;
            $this$apply.close();
            if ($this$apply.getRefCount() <= 0) {
                this.sessionMap.remove(key);
            }
        }
    }

    @Override
    public void close() {
        Map<String, Session> $this$forEach$iv = this.sessionMap;
        boolean $i$f$forEach = false;
        Map<String, Session> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, Session>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Session> element$iv;
            Map.Entry<String, Session> $dstr$key$_u24__u24 = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, Session> entry = $dstr$key$_u24__u24;
            boolean bl3 = false;
            String key = entry.getKey();
            this.closeSession(key);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Session> authedSessions() {
        void $this$mapTo$iv$iv;
        Map<String, Session> $this$filterValues$iv = this.sessionMap;
        boolean $i$f$filterValues = false;
        Map<String, Session> result$iv = new LinkedHashMap();
        Map<String, Session> map = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<String, Session> entry$iv : map.entrySet()) {
            Session it = entry$iv.getValue();
            boolean bl2 = false;
            if (!it.isAuthed()) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$map$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Map.Entry<String, Session>> iterator = $this$mapTo$iv$iv;
        boolean bl3 = false;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            Session session = (Session)it.getValue();
            collection.add(session);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MessageSourceCache getCache(long id) {
        MessageSourceCache cache = this.cacheMap.get(id);
        if (cache == null) {
            DefaultSessionManager defaultSessionManager = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (defaultSessionManager) {
                boolean bl3 = false;
                if (cache == null) {
                    cache = new MessageSourceCache(MainSetting.INSTANCE.getCacheSize());
                    this.cacheMap.put(id, cache);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        MessageSourceCache messageSourceCache = cache;
        Intrinsics.checkNotNull((Object)messageSourceCache);
        return messageSourceCache;
    }

    @Override
    @NotNull
    public String getVerifyKey() {
        return this.verifyKey;
    }

    @NotNull
    public final MahContext getContext() {
        return this.context;
    }

    public DefaultSessionManager(@NotNull String verifyKey, @NotNull MahContext context) {
        Intrinsics.checkNotNullParameter((Object)verifyKey, (String)"verifyKey");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.verifyKey = verifyKey;
        this.context = context;
        boolean bl = false;
        this.sessionMap = new LinkedHashMap();
        bl = false;
        this.cacheMap = new LinkedHashMap();
    }
}

