/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.api.http.context.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001b\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0005R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/mamoe/mirai/api/http/context/cache/LRUCache;", "K", "", "V", "cacheSize", "", "(I)V", "cacheData", "Ljava/util/concurrent/ConcurrentHashMap;", "lruQueen", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "lru", "", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "size", "mirai-api-http"})
public class LRUCache<K, V> {
    private final ConcurrentLinkedQueue<K> lruQueen;
    private final ConcurrentHashMap<K, V> cacheData;
    private final int cacheSize;

    @Nullable
    public V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.cacheData.get(key);
    }

    public final void put(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        V old = this.cacheData.put(key, value);
        if (old == null) {
            this.lruQueen.offer(key);
            this.lru();
        }
    }

    private final void lru() {
        while (this.lruQueen.size() > this.cacheSize) {
            K poll = this.lruQueen.poll();
            this.cacheData.remove(poll);
        }
    }

    public final int size() {
        return this.cacheData.size();
    }

    public LRUCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.lruQueen = new ConcurrentLinkedQueue();
        this.cacheData = new ConcurrentHashMap();
    }
}

