/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.kjbb.compiler.diagnostic;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.kjbb.compiler.backend.jvm.AnalyzeCapabilityForGeneratingBridgesKt;
import net.mamoe.kjbb.compiler.backend.jvm.AnalyzingKt;
import net.mamoe.kjbb.compiler.backend.jvm.BlockingBridgeAnalyzeResult;
import net.mamoe.kjbb.compiler.backend.jvm.UtilKt;
import net.mamoe.kjbb.compiler.diagnostic.BlockingBridgeDeclarationChecker$WhenMappings;
import net.mamoe.kjbb.compiler.diagnostic.BlockingBridgeErrors;
import net.mamoe.kjbb.compiler.extensions.IBridgeConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/mamoe/kjbb/compiler/diagnostic/BlockingBridgeDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "isIr", "", "ext", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lnet/mamoe/kjbb/compiler/extensions/IBridgeConfiguration;", "(ZLkotlin/jvm/functions/Function1;)V", "check", "", "declaration", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkApplicability", "Lnet/mamoe/kjbb/compiler/diagnostic/BlockingBridgeDeclarationChecker$CheckResult;", "checkJvmSynthetic", "isPluginEnabled", "CheckResult", "Companion", "kotlin-jvm-blocking-bridge-compiler"})
public class BlockingBridgeDeclarationChecker
implements DeclarationChecker {
    private final boolean isIr;
    private final Function1<KtDeclaration, IBridgeConfiguration> ext;
    private static final FqName JVM_SYNTHETIC;
    @NotNull
    public static final Companion Companion;

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtDeclaration ktDeclaration = declaration;
        if (ktDeclaration instanceof KtClass) {
            PsiElement psiElement = AnalyzingKt.jvmBlockingBridgeAnnotationPsi(descriptor);
            if (psiElement == null) {
                return;
            }
            PsiElement annotation = psiElement;
            if (!this.isPluginEnabled(descriptor)) {
                SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.BLOCKING_BRIDGE_PLUGIN_NOT_ENABLED.on(annotation);
                Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"BLOCKING_BRIDGE_PLUGIN_NOT_ENABLED.on(annotation)");
                AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
                return;
            }
            if (((KtClass)declaration).isInterface()) {
                TargetPlatform targetPlatform = DescriptorUtilsKt.getModule((DeclarationDescriptor)descriptor).getPlatform();
                if (targetPlatform == null || !AnalyzingKt.isJvm8OrHigher(targetPlatform)) {
                    SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.INTERFACE_NOT_SUPPORTED.on(annotation);
                    Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"INTERFACE_NOT_SUPPORTED.on(annotation)");
                    AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
                    return;
                }
            }
        } else if (ktDeclaration instanceof KtNamedFunction) {
            CheckResult checkResult = CheckResult.BREAK;
            if (checkResult == this.checkApplicability(declaration, descriptor, context) || checkResult == this.checkJvmSynthetic(declaration, descriptor, context)) {
                return;
            }
            return;
        }
    }

    protected boolean isPluginEnabled(@NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return true;
    }

    private final CheckResult checkApplicability(KtDeclaration declaration, DeclarationDescriptor descriptor, DeclarationCheckerContext context) {
        PsiElement psiElement;
        Object object = this.ext.invoke((Object)declaration);
        boolean bl = false;
        boolean bl2 = false;
        IBridgeConfiguration $this$with = (IBridgeConfiguration)object;
        boolean bl3 = false;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
        switch (BlockingBridgeDeclarationChecker$WhenMappings.$EnumSwitchMapping$0[UtilKt.hasJvmBlockingBridgeAnnotation(descriptor, bindingContext, $this$with.getEnableForModule()).ordinal()]) {
            case 1: {
                return CheckResult.CONTINUE;
            }
            case 2: 
            case 3: {
                return CheckResult.CONTINUE;
            }
            case 4: {
                psiElement = AnalyzingKt.jvmBlockingBridgeAnnotationPsi(descriptor);
                if (psiElement != null) break;
                psiElement = (PsiElement)declaration;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PsiElement inspectionTarget = psiElement;
        if (!this.isPluginEnabled(descriptor)) {
            SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.BLOCKING_BRIDGE_PLUGIN_NOT_ENABLED.on(inspectionTarget);
            Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"BLOCKING_BRIDGE_PLUGIN_N\u2026BLED.on(inspectionTarget)");
            AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
            return CheckResult.BREAK;
        }
        if (!(descriptor instanceof FunctionDescriptor)) {
            SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.INAPPLICABLE_JVM_BLOCKING_BRIDGE.on(inspectionTarget);
            Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"INAPPLICABLE_JVM_BLOCKIN\u2026IDGE.on(inspectionTarget)");
            AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
            return CheckResult.BREAK;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        BindingContext bindingContext2 = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"context.trace.bindingContext");
        BlockingBridgeAnalyzeResult result = AnalyzeCapabilityForGeneratingBridgesKt.analyzeCapabilityForGeneratingBridges(functionDescriptor, this.isIr, bindingContext2, $this$with);
        Diagnostic diagnostic = result.createDiagnostic();
        if (diagnostic != null) {
            Diagnostic diagnostic2 = diagnostic;
            DeclarationCheckerContext declarationCheckerContext = context;
            boolean bl4 = false;
            boolean bl5 = false;
            Diagnostic p1 = diagnostic2;
            boolean bl6 = false;
            AnalyzingKt.report(declarationCheckerContext, p1);
        }
        if (result instanceof BlockingBridgeAnalyzeResult.BridgeAnnotationFromContainingDeclaration) {
            return CheckResult.BREAK;
        }
        return CheckResult.CONTINUE;
    }

    private final CheckResult checkJvmSynthetic(KtDeclaration declaration, DeclarationDescriptor descriptor, DeclarationCheckerContext context) {
        PsiElement psiElement;
        Object object = this.ext.invoke((Object)declaration);
        boolean bl = false;
        boolean bl2 = false;
        IBridgeConfiguration $this$with = (IBridgeConfiguration)object;
        boolean bl3 = false;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
        switch (BlockingBridgeDeclarationChecker$WhenMappings.$EnumSwitchMapping$1[UtilKt.hasJvmBlockingBridgeAnnotation(descriptor, bindingContext, $this$with.getEnableForModule()).ordinal()]) {
            case 1: {
                return CheckResult.CONTINUE;
            }
            case 2: {
                Object object2 = AnalyzingKt.jvmBlockingBridgeAnnotationPsi(descriptor);
                if (object2 == null) {
                    AnnotationDescriptor annotationDescriptor = descriptor.getAnnotations().findAnnotation(JVM_SYNTHETIC);
                    object2 = psiElement = annotationDescriptor != null ? AnalyzingKt.findPsi(annotationDescriptor) : null;
                }
                if (object2 != null) break;
                psiElement = (PsiElement)declaration;
                break;
            }
            case 3: 
            case 4: {
                return CheckResult.CONTINUE;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PsiElement inspectionTarget = psiElement;
        if (JvmAnnotationUtilKt.hasJvmSyntheticAnnotation((DeclarationDescriptor)descriptor)) {
            SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.REDUNDANT_JVM_BLOCKING_BRIDGE_WITH_JVM_SYNTHETIC.on(inspectionTarget);
            Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"REDUNDANT_JVM_BLOCKING_B\u2026ETIC.on(inspectionTarget)");
            AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
            return CheckResult.CONTINUE;
        }
        return CheckResult.CONTINUE;
    }

    public BlockingBridgeDeclarationChecker(boolean isIr, @NotNull Function1<? super KtDeclaration, ? extends IBridgeConfiguration> ext) {
        Intrinsics.checkNotNullParameter(ext, (String)"ext");
        this.isIr = isIr;
        this.ext = ext;
    }

    static {
        Companion = new Companion(null);
        JVM_SYNTHETIC = new FqName("kotlin.jvm.JvmSynthetic");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/mamoe/kjbb/compiler/diagnostic/BlockingBridgeDeclarationChecker$CheckResult;", "", "(Ljava/lang/String;I)V", "CONTINUE", "BREAK", "kotlin-jvm-blocking-bridge-compiler"})
    public static final class CheckResult
    extends Enum<CheckResult> {
        public static final /* enum */ CheckResult CONTINUE;
        public static final /* enum */ CheckResult BREAK;
        private static final /* synthetic */ CheckResult[] $VALUES;

        static {
            CheckResult[] checkResultArray = new CheckResult[2];
            CheckResult[] checkResultArray2 = checkResultArray;
            checkResultArray[0] = CONTINUE = new CheckResult();
            checkResultArray[1] = BREAK = new CheckResult();
            $VALUES = checkResultArray;
        }

        public static CheckResult[] values() {
            return (CheckResult[])$VALUES.clone();
        }

        public static CheckResult valueOf(String string) {
            return Enum.valueOf(CheckResult.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/mamoe/kjbb/compiler/diagnostic/BlockingBridgeDeclarationChecker$Companion;", "", "()V", "JVM_SYNTHETIC", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin-jvm-blocking-bridge-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

