/*
 * Decompiled with CFR 0.152.
 */
package net.mailific.mailificserverspringboot;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.mailific.mailificserverspringboot.BannerDomainProvider;
import net.mailific.mailificserverspringboot.CommandHandlerProvider;
import net.mailific.mailificserverspringboot.EhloGreetingProvider;
import net.mailific.mailificserverspringboot.ExtensionProvider;
import net.mailific.main.Main;
import net.mailific.server.LineConsumer;
import net.mailific.server.MailObjectFactory;
import net.mailific.server.ServerConfig;
import net.mailific.server.SmtpCommandMap;
import net.mailific.server.SmtpServer;
import net.mailific.server.commands.CommandHandler;
import net.mailific.server.commands.Connect;
import net.mailific.server.extension.starttls.StartTls;
import net.mailific.server.netty.NettySmtpServer;
import net.mailific.server.reference.BaseMailObjectFactory;
import net.mailific.server.session.SmtpSessionFactory;
import net.mailific.server.session.SmtpSessionFactoryImp;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class Autoconf {
    @Bean
    @ConditionalOnMissingBean
    public SmtpServer smtpServer(ServerConfig config) {
        return new NettySmtpServer(config);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerConfig serverConfig(@Value(value="${mailific.server.listenHost:localhost}") String listenHost, @Value(value="${mailific.server.listenPort:2525}") int listenPort, @Value(value="${mailific.server.certPath:}") String certPath, @Value(value="${mailific.server.certKeyPath:}") String certKeyPath, @Value(value="${mailific.server.certPassword:#{NULL}}") String certPass, SmtpSessionFactory sessionFactory) {
        ServerConfig.Builder builder = ServerConfig.builder().withListenHost(listenHost).withListenPort(listenPort).withSessionFactory(sessionFactory);
        if (certPath != null && !certPath.isBlank()) {
            if (certKeyPath == null || certKeyPath.isBlank()) {
                throw new IllegalArgumentException("If you provide a cert, you must provide the key.");
            }
            File certFile = new File(certPath);
            File certKeyFile = new File(certKeyPath);
            if (!certFile.canRead()) {
                throw new IllegalArgumentException("Cannot read cert file: " + certPath);
            }
            if (!certKeyFile.canRead()) {
                throw new IllegalArgumentException("Cannot read cert key: " + certKeyPath);
            }
            builder.withTlsCert(certFile).withTlsCertKey(certKeyFile).withTlsCertPassword(certPass);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public SmtpSessionFactory smtpSesssionFactory(@Qualifier(value="mailificCommandConsumer") LineConsumer commandConsumer, ExtensionProvider extensions) {
        return new SmtpSessionFactoryImp(commandConsumer, extensions.extensions());
    }

    @Bean
    @ConditionalOnMissingBean
    public ExtensionProvider extensionProvider(@Value(value="${mailific.server.certPath:}") String certPath) {
        List extensions = Main.harmlessExtensions();
        if (!certPath.isBlank()) {
            extensions.add(new StartTls());
        }
        return () -> extensions;
    }

    @Bean
    @ConditionalOnMissingBean(name={"mailificCommandConsumer"})
    public LineConsumer mailificCommandConsumer(CommandHandlerProvider commands) {
        return new SmtpCommandMap(commands.commandHandlers(), commands.connectHandler());
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandHandlerProvider commandHandlerProvider(final BannerDomainProvider domain, final EhloGreetingProvider greeting, final MailObjectFactory mailObjectFactory, final @Qualifier(value="commandOverrides") Collection<CommandHandler> commandOverrides) {
        return new CommandHandlerProvider(){

            @Override
            public Collection<CommandHandler> commandHandlers() {
                Map handlers = Main.baseCommandHandlers((String)domain.getBannerDomain(), (String)greeting.getEhloGreeting(), (MailObjectFactory)mailObjectFactory);
                if (commandOverrides != null) {
                    commandOverrides.forEach(c -> handlers.put(c.verb().toUpperCase(), c));
                }
                return handlers.values();
            }

            @Override
            public CommandHandler connectHandler() {
                return new Connect(domain.getBannerDomain());
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public MailObjectFactory mailObjectFactory() {
        return new BaseMailObjectFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public BannerDomainProvider bannerDomainProvider() {
        return () -> Main.domainFromHost((String)Main.defaultListenHost());
    }

    @Bean
    @ConditionalOnMissingBean
    public EhloGreetingProvider ehloGreetingProvider() {
        return () -> null;
    }

    @Bean
    @ConditionalOnMissingBean(name={"commandOverrides"})
    Collection<CommandHandler> commandOverrides(BannerDomainProvider domain, EhloGreetingProvider greeting, MailObjectFactory mailObjectFactory) {
        return Collections.emptyList();
    }
}

