/*
 * Decompiled with CFR 0.152.
 */
package net.midea.dataextractor.mvn;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.FieldSpec;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.TypeSpec;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.lang.model.element.Modifier;
import lombok.Data;
import net.midea.dataextractor.Dto;
import net.midea.dataextractor.DtoDescriptor;
import net.midea.dataextractor.DtoDescriptorField;
import net.midea.dataextractor.DtoDescriptorRecord;
import net.midea.dataextractor.DtoFieldType;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-dto", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateDTOMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private File descriptorFile;
    @Parameter(defaultValue="${project.groupId}", required=true)
    private String targetPackage;
    @Parameter(defaultValue="DTO", required=true)
    private String prefix;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/dto/", required=true)
    private String targetDir;
    ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.descriptorFile == null) {
            throw new MojoFailureException("descriptorFile cannot be null");
        }
        try (FileInputStream fis = new FileInputStream(this.descriptorFile);){
            DtoDescriptor descriptor = (DtoDescriptor)this.objectMapper.readValue((InputStream)fis, DtoDescriptor.class);
            for (DtoDescriptorRecord header : descriptor.getHeaders()) {
                this.generateSource(header);
            }
            for (DtoDescriptorRecord content : descriptor.getContent()) {
                this.generateSource(content);
            }
            for (DtoDescriptorRecord footer : descriptor.getTrailers()) {
                this.generateSource(footer);
            }
            this.getLog().info((CharSequence)("adding source root " + this.targetDir));
            this.project.addCompileSourceRoot(this.targetDir);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Failed to read descriptor file", (Throwable)e);
            throw new MojoExecutionException("Failed to read descriptor file", (Exception)e);
        }
    }

    private void generateSource(DtoDescriptorRecord record) throws IOException {
        this.getLog().info((CharSequence)("generating dto for " + record.getName()));
        File of = new File(this.targetDir);
        TypeSpec.Builder dtoType = TypeSpec.classBuilder((String)(this.prefix + record.getName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Data.class).addAnnotation(AnnotationSpec.builder(Dto.class).addMember("value", "$S", new Object[]{record.getName()}).build());
        for (DtoDescriptorField field : record.getFields()) {
            FieldSpec fieldSpec = FieldSpec.builder((Type)this.mapType(field.getType()), (String)field.getName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
            dtoType.addField(fieldSpec);
        }
        JavaFile javaFile = JavaFile.builder((String)this.targetPackage, (TypeSpec)dtoType.build()).build();
        javaFile.writeTo(of);
    }

    private Type mapType(DtoFieldType type) {
        return switch (type) {
            case DtoFieldType.DATE -> LocalDate.class;
            case DtoFieldType.TIME -> LocalTime.class;
            case DtoFieldType.DATETIME -> LocalDateTime.class;
            case DtoFieldType.INSTANT -> Instant.class;
            case DtoFieldType.BINARY -> byte[].class;
            case DtoFieldType.NUMBER -> BigDecimal.class;
            default -> String.class;
        };
    }
}

