/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.nimbusds.openid.connect.sdk.claims.SessionID;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionIdListener;
import java.util.Objects;
import net.ltgt.oidc.servlet.LoggedOutSessionStore;
import net.ltgt.oidc.servlet.SessionInfo;
import org.jspecify.annotations.Nullable;

public class BackchannelLogoutSessionListener
implements HttpSessionAttributeListener,
HttpSessionIdListener {
    private @Nullable LoggedOutSessionStore loggedOutSessionStore;

    public BackchannelLogoutSessionListener() {
    }

    public BackchannelLogoutSessionListener(LoggedOutSessionStore loggedOutSessionStore) {
        this.loggedOutSessionStore = Objects.requireNonNull(loggedOutSessionStore);
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (event.getName().equals(SessionInfo.SESSION_ATTRIBUTE_NAME)) {
            SessionID sid = ((SessionInfo)event.getValue()).getIDTokenClaims().getSessionID();
            LoggedOutSessionStore loggedOutSessionStore = this.getLoggedOutSessionStore(event.getSession());
            if (sid != null && loggedOutSessionStore != null) {
                loggedOutSessionStore.acquire(sid, event.getSession().getId());
            }
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (event.getName().equals(SessionInfo.SESSION_ATTRIBUTE_NAME)) {
            SessionID sid = ((SessionInfo)event.getValue()).getIDTokenClaims().getSessionID();
            LoggedOutSessionStore loggedOutSessionStore = this.getLoggedOutSessionStore(event.getSession());
            if (sid != null && loggedOutSessionStore != null) {
                loggedOutSessionStore.release(sid, event.getSession().getId());
            }
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        LoggedOutSessionStore loggedOutSessionStore;
        SessionID newSid;
        SessionID oldSid;
        if (event.getName().equals(SessionInfo.SESSION_ATTRIBUTE_NAME) && !Objects.equals(oldSid = ((SessionInfo)event.getValue()).getIDTokenClaims().getSessionID(), newSid = ((SessionInfo)event.getSession().getAttribute(SessionInfo.SESSION_ATTRIBUTE_NAME)).getIDTokenClaims().getSessionID()) && (loggedOutSessionStore = this.getLoggedOutSessionStore(event.getSession())) != null) {
            if (oldSid != null) {
                loggedOutSessionStore.release(oldSid, event.getSession().getId());
            }
            if (newSid != null) {
                loggedOutSessionStore.acquire(newSid, event.getSession().getId());
            }
        }
    }

    public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
        SessionID sid = ((SessionInfo)event.getSession().getAttribute(SessionInfo.SESSION_ATTRIBUTE_NAME)).getIDTokenClaims().getSessionID();
        LoggedOutSessionStore loggedOutSessionStore = this.getLoggedOutSessionStore(event.getSession());
        if (sid != null && loggedOutSessionStore != null) {
            loggedOutSessionStore.renew(sid, oldSessionId, event.getSession().getId());
        }
    }

    private @Nullable LoggedOutSessionStore getLoggedOutSessionStore(HttpSession session) {
        if (this.loggedOutSessionStore != null) {
            return this.loggedOutSessionStore;
        }
        return (LoggedOutSessionStore)session.getServletContext().getAttribute(LoggedOutSessionStore.CONTEXT_ATTRIBUTE_NAME);
    }
}

