/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.io.Serializable;
import java.util.Objects;

public final class SessionInfo
implements Serializable {
    static final String SESSION_ATTRIBUTE_NAME = SessionInfo.class.getName();
    private final JWT idToken;
    private final IDTokenClaimsSet idTokenClaims;
    private final UserInfo userInfo;

    public SessionInfo(JWT idToken, IDTokenClaimsSet idTokenClaims, UserInfo userInfo) {
        this.idToken = idToken;
        this.idTokenClaims = Objects.requireNonNull(idTokenClaims);
        this.userInfo = Objects.requireNonNull(userInfo);
    }

    public JWT getIDToken() {
        return this.idToken;
    }

    public IDTokenClaimsSet getIDTokenClaims() {
        return this.idTokenClaims;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    private Object writeReplace() {
        return new SerializableSessionInfo(this.idToken.serialize(), this.userInfo.toJSONString());
    }

    private record SerializableSessionInfo(String idToken, String serializedUserInfo) implements Serializable
    {
        Object readResolve() {
            try {
                JWT parsedIdToken = JWTParser.parse((String)this.idToken());
                IDTokenClaimsSet idTokenClaims = new IDTokenClaimsSet(parsedIdToken.getJWTClaimsSet());
                UserInfo userInfo = UserInfo.parse((String)this.serializedUserInfo());
                return new SessionInfo(parsedIdToken, idTokenClaims, userInfo);
            }
            catch (ParseException | java.text.ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

