/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.google.errorprone.annotations.ForOverride;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.TokenRevocationRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequestSender;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.Token;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import net.ltgt.oidc.servlet.Configuration;
import net.ltgt.oidc.servlet.OAuthTokensHandler;
import org.jspecify.annotations.Nullable;

public class RevokingOAuthTokensHandler
implements OAuthTokensHandler {
    private final Configuration configuration;
    private final @Nullable HTTPRequestSender httpRequestSender;
    private final Executor executor;

    public RevokingOAuthTokensHandler(Configuration configuration) {
        this(configuration, (HTTPRequestSender)null);
    }

    public RevokingOAuthTokensHandler(Configuration configuration, @Nullable HTTPRequestSender httpRequestSender) {
        this(configuration, httpRequestSender, ForkJoinPool.commonPool());
    }

    public RevokingOAuthTokensHandler(Configuration configuration, Executor executor) {
        this(configuration, null, executor);
    }

    public RevokingOAuthTokensHandler(Configuration configuration, @Nullable HTTPRequestSender httpRequestSender, Executor executor) {
        this.configuration = Objects.requireNonNull(configuration);
        this.httpRequestSender = httpRequestSender;
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public void tokensAcquired(AccessTokenResponse tokenResponse, HttpSession session) {
        this.executor.execute(() -> {
            try {
                this.revoke((Token)tokenResponse.getTokens().getAccessToken());
            }
            catch (IOException e) {
                this.handleError(e);
            }
        });
    }

    private void revoke(Token token) throws IOException {
        TokenRevocationRequest request = new TokenRevocationRequest(this.configuration.getProviderMetadata().getRevocationEndpointURI(), this.configuration.getClientAuthentication(), token);
        HTTPResponse response = this.send(request);
        if (!response.indicatesSuccess()) {
            this.handleError(response);
        }
    }

    private HTTPResponse send(TokenRevocationRequest request) throws IOException {
        if (this.httpRequestSender != null) {
            return request.toHTTPRequest().send(this.httpRequestSender);
        }
        return request.toHTTPRequest().send();
    }

    @ForOverride
    protected void handleError(Exception e) {
        Exception exception = e;
        Objects.requireNonNull(exception);
        Exception exception2 = exception;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RuntimeException.class, IOException.class}, (Object)exception2, n)) {
            case 0: {
                RuntimeException re = (RuntimeException)exception2;
                throw re;
            }
            case 1: {
                IOException ioe = (IOException)exception2;
                throw new UncheckedIOException(ioe);
            }
        }
        throw new RuntimeException(e);
    }

    @ForOverride
    protected void handleError(HTTPResponse response) {
    }
}

