/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.LogoutRequest;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URI;
import net.ltgt.oidc.servlet.Configuration;
import net.ltgt.oidc.servlet.LogoutState;
import net.ltgt.oidc.servlet.SessionInfo;
import net.ltgt.oidc.servlet.Utils;
import org.jspecify.annotations.Nullable;

public class LogoutServlet
extends HttpServlet {
    public static final String POST_LOGOUT_REDIRECT_PATH = "post-logout-redirect-path";
    public static final String USE_LOGOUT_STATE = "use-logout-state";
    private Configuration configuration;
    private @Nullable String postLogoutRedirectPath;
    private Boolean useLogoutState;

    public LogoutServlet() {
    }

    public LogoutServlet(String postLogoutRedirectPath) {
        this(postLogoutRedirectPath, false);
    }

    public LogoutServlet(String postLogoutRedirectPath, boolean useLogoutState) {
        this.postLogoutRedirectPath = postLogoutRedirectPath;
        this.useLogoutState = useLogoutState;
    }

    public void init() throws ServletException {
        this.configuration = (Configuration)this.getServletContext().getAttribute(Configuration.CONTEXT_ATTRIBUTE_NAME);
        if (this.postLogoutRedirectPath == null) {
            this.postLogoutRedirectPath = this.getInitParameter(POST_LOGOUT_REDIRECT_PATH);
        }
        if (this.useLogoutState == null) {
            this.useLogoutState = Boolean.parseBoolean(this.getInitParameter(USE_LOGOUT_STATE));
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        State state;
        if (!Utils.isNavigation(req)) {
            resp.sendError(400);
            return;
        }
        if (!Utils.isSameOrigin(req)) {
            Utils.sendRedirect(resp, "/");
            return;
        }
        HttpSession session = req.getSession(false);
        if (session == null) {
            Utils.sendRedirect(resp, "/");
            return;
        }
        SessionInfo sessionInfo = (SessionInfo)session.getAttribute(SessionInfo.SESSION_ATTRIBUTE_NAME);
        session.invalidate();
        if (sessionInfo == null) {
            Utils.sendRedirect(resp, "/");
            return;
        }
        if (this.postLogoutRedirectPath == null || !this.useLogoutState.booleanValue()) {
            state = null;
        } else {
            state = new State();
            req.getSession().setAttribute(LogoutState.SESSION_ATTRIBUTE_NAME, (Object)new LogoutState(state, Utils.getReturnToParameter(req)));
        }
        LogoutRequest logoutRequest = new LogoutRequest(this.configuration.getProviderMetadata().getEndSessionEndpointURI(), sessionInfo.getOIDCTokens().getIDToken(), this.postLogoutRedirectPath != null ? URI.create(req.getRequestURL().toString()).resolve(this.postLogoutRedirectPath) : null, state);
        Utils.sendRedirect(resp, logoutRequest.toURI().toASCIIString());
    }
}

