/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.nimbusds.openid.connect.sdk.claims.SessionID;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import net.ltgt.oidc.servlet.LoggedOutSessionStore;

public class InMemoryLoggedOutSessionStore
implements LoggedOutSessionStore {
    private final Set<SessionID> loggedOutSessions = new ConcurrentSkipListSet<SessionID>();

    @Override
    public void logout(SessionID sessionID) {
        this.loggedOutSessions.add(sessionID);
    }

    @Override
    public boolean isLoggedOut(SessionID sessionID) {
        return this.loggedOutSessions.contains(sessionID);
    }

    @Override
    public void forget(SessionID sessionID) {
        this.loggedOutSessions.remove(sessionID);
    }
}

