/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.openid.connect.sdk.claims.LogoutTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.LogoutTokenValidator;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Set;
import net.ltgt.oidc.servlet.Configuration;
import net.ltgt.oidc.servlet.LoggedOutSessionStore;
import org.jspecify.annotations.Nullable;

public class BackchannelLogoutServlet
extends HttpServlet {
    private LoggedOutSessionStore loggedOutSessionStore;
    private LogoutTokenValidator logoutTokenValidator;

    public void init() throws ServletException {
        this.loggedOutSessionStore = (LoggedOutSessionStore)this.getServletContext().getAttribute(LoggedOutSessionStore.CONTEXT_ATTRIBUTE_NAME);
        Configuration configuration = (Configuration)this.getServletContext().getAttribute(Configuration.CONTEXT_ATTRIBUTE_NAME);
        try {
            this.logoutTokenValidator = new LogoutTokenValidator(configuration.getProviderMetadata().getIssuer(), configuration.getClientAuthentication().getClientID(), false, (JWSKeySelector)new JWSVerificationKeySelector(Set.copyOf(configuration.getProviderMetadata().getIDTokenJWSAlgs()), JWKSourceBuilder.create((URL)configuration.getProviderMetadata().getJWKSetURI().toURL()).build()), null);
        }
        catch (MalformedURLException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LogoutTokenClaimsSet logoutTokenClaims;
        JWT logoutToken;
        String logoutTokenParam = req.getParameter("logout_token");
        if (logoutTokenParam == null) {
            this.sendError(resp, "Missing logout token", null);
            return;
        }
        try {
            logoutToken = JWTParser.parse((String)logoutTokenParam);
        }
        catch (ParseException e) {
            this.sendError(resp, "Error parsing logout token", e);
            return;
        }
        try {
            logoutTokenClaims = this.logoutTokenValidator.validate(logoutToken);
        }
        catch (BadJOSEException e) {
            this.sendError(resp, "Error validating logout token", e);
            return;
        }
        catch (JOSEException e) {
            this.sendError(resp, "Invalid logout token", e);
            return;
        }
        this.loggedOutSessionStore.logout(logoutTokenClaims.getSessionID());
        resp.setHeader("Cache-Control", "no-store");
        resp.setStatus(200);
    }

    private void sendError(HttpServletResponse resp, String message, @Nullable Throwable cause) throws IOException {
        if (cause != null) {
            this.log(message, cause);
        }
        resp.sendError(400, message);
    }
}

