/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet.rs;

import com.google.errorprone.annotations.ForOverride;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import jakarta.annotation.Priority;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import net.ltgt.oidc.servlet.rs.AuthenticationRedirector;
import net.ltgt.oidc.servlet.rs.Utils;

@Priority(value=2000)
public abstract class AbstractAuthorizationFilter
implements ContainerRequestFilter {
    public static final String IS_PRIVATE_PROPERTY_NAME = net.ltgt.oidc.servlet.AbstractAuthorizationFilter.IS_PRIVATE_REQUEST_ATTRIBUTE_NAME;
    @Context
    protected HttpServletRequest servletRequest;

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (this.isAuthorized(containerRequestContext.getSecurityContext())) {
            containerRequestContext.setProperty(IS_PRIVATE_PROPERTY_NAME, (Object)true);
            return;
        }
        if (Utils.isNavigation(containerRequestContext) && Utils.isSafeMethod(containerRequestContext)) {
            this.redirectToAuthenticationEndpoint(containerRequestContext);
            return;
        }
        this.sendUnauthorized(containerRequestContext);
    }

    protected abstract boolean isAuthorized(SecurityContext var1);

    @ForOverride
    protected void redirectToAuthenticationEndpoint(ContainerRequestContext containerRequestContext) {
        if (containerRequestContext.getSecurityContext().getUserPrincipal() == null) {
            this.doRedirectToAuthenticationEndpoint(containerRequestContext);
        } else {
            this.sendForbidden(containerRequestContext);
        }
    }

    @ForOverride
    protected void doRedirectToAuthenticationEndpoint(ContainerRequestContext containerRequestContext) {
        AuthenticationRedirector authenticationRedirector = this.getAuthenticationRedirector();
        authenticationRedirector.redirectToAuthenticationEndpoint(containerRequestContext, this.servletRequest, containerRequestContext.getUriInfo().getRequestUri().toASCIIString(), builder -> this.configureAuthenticationRequest(containerRequestContext, (AuthenticationRequest.Builder)builder));
    }

    @ForOverride
    protected AuthenticationRedirector getAuthenticationRedirector() {
        return (AuthenticationRedirector)((Object)this.servletRequest.getServletContext().getAttribute(AuthenticationRedirector.CONTEXT_ATTRIBUTE_NAME));
    }

    @ForOverride
    protected void configureAuthenticationRequest(ContainerRequestContext containerRequestContext, AuthenticationRequest.Builder builder) {
    }

    @ForOverride
    protected void sendUnauthorized(ContainerRequestContext containerRequestContext) {
        if (containerRequestContext.getSecurityContext().getUserPrincipal() == null) {
            this.doSendUnauthorized(containerRequestContext);
        } else {
            this.sendForbidden(containerRequestContext);
        }
    }

    @ForOverride
    protected void doSendUnauthorized(ContainerRequestContext containerRequestContext) {
        throw new NotAuthorizedException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }

    @ForOverride
    protected void sendForbidden(ContainerRequestContext containerRequestContext) {
        throw new ForbiddenException();
    }
}

