/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet.rs;

import com.google.errorprone.annotations.ForOverride;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.util.Objects;
import net.ltgt.oidc.servlet.UserPrincipal;
import net.ltgt.oidc.servlet.rs.AbstractAuthorizationFilter;

@Priority(value=2000)
public class HasRoleFilter
extends AbstractAuthorizationFilter {
    private final String role;

    public HasRoleFilter(String role) {
        this.role = Objects.requireNonNull(role);
    }

    @Override
    protected final boolean isAuthorized(SecurityContext securityContext) {
        Principal principal = securityContext.getUserPrincipal();
        if (principal instanceof UserPrincipal) {
            UserPrincipal userPrincipal = (UserPrincipal)principal;
            return userPrincipal.hasRole(this.role);
        }
        return false;
    }

    @Override
    @ForOverride
    protected void redirectToAuthenticationEndpoint(ContainerRequestContext containerRequestContext) {
        if (containerRequestContext.getSecurityContext().getUserPrincipal() == null) {
            this.doRedirectToAuthenticationEndpoint(containerRequestContext);
        } else {
            this.sendForbidden(containerRequestContext);
        }
    }

    protected final void doRedirectToAuthenticationEndpoint(ContainerRequestContext containerRequestContext) {
        super.redirectToAuthenticationEndpoint(containerRequestContext);
    }

    @Override
    @ForOverride
    protected void sendUnauthorized(ContainerRequestContext containerRequestContext) {
        if (containerRequestContext.getSecurityContext().getUserPrincipal() == null) {
            this.doSendUnauthorized(containerRequestContext);
        } else {
            this.sendForbidden(containerRequestContext);
        }
    }

    protected final void doSendUnauthorized(ContainerRequestContext containerRequestContext) {
        super.sendUnauthorized(containerRequestContext);
    }

    @ForOverride
    protected void sendForbidden(ContainerRequestContext containerRequestContext) {
        throw new ForbiddenException();
    }
}

