package net.lsafer.compose.simpleform

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock

class ActionState {
    private val mutex = Mutex()
    var isLoading by mutableStateOf(false)
        private set

    suspend fun use(block: suspend CoroutineScope.() -> Unit) {
        mutex.withLock {
            try {
                isLoading = true
                coroutineScope {
                    block()
                }
            } finally {
                isLoading = false
            }
        }
    }
}

context(vm: ViewModel)
fun ActionState.useIO(block: suspend CoroutineScope.() -> Unit): Job {
    return vm.viewModelScope.launch { use(block) }
}
