/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Init.Extensions;

import LinkFuture.Init.ObjectExtend.Callback;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class StringExtension {
    private static final String regexPattern = "\\{[^\\}\\{]*\\}";
    private static final Pattern regexReplacePattern = Pattern.compile("\\{[^\\}\\{]*\\}");

    public static String TrimStart(String input, String trimString) {
        if (input.startsWith(trimString)) {
            return input.substring(trimString.length(), input.length());
        }
        return input;
    }

    public static String TrimEnd(String input, String trimString) {
        if (input.endsWith(trimString)) {
            int index = input.length() - trimString.length();
            return input.substring(0, index);
        }
        return input;
    }

    public static boolean IsNullOrEmpty(Object str) {
        return str == null || str.toString().length() == 0;
    }

    public static int Length(CharSequence str) {
        return str == null ? 0 : str.length();
    }

    public static boolean IsUrl(String url) {
        try {
            URL u = new URL(url);
            u.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String Join(Collection<?> s, String delimiter) {
        return StringExtension.Join(s, delimiter, null);
    }

    public static String Join(Collection<?> s, String delimiter, Callback<String, String> fun) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> item = s.iterator();
        while (item.hasNext()) {
            builder.append(item.next());
            if (!item.hasNext()) break;
            if (fun != null) {
                builder.append(fun.call(delimiter));
                continue;
            }
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String XmlEscape(String string) {
        StringBuilder sb = new StringBuilder();
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String JsonQuote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return StringExtension.JsonQuote(string, sw).toString();
            }
            catch (IOException ignored) {
                return "";
            }
        }
    }

    public static String JsonDeQuote(String string) {
        JSONObject obj = new JSONObject("{\"a\":" + string + "}");
        return obj.getString("a");
    }

    public static String removeQuote(String string) {
        StringWriter sw = new StringWriter();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            if (i == 0 && (string.charAt(i) == '\'' || string.charAt(i) == '\"') || i == len - 1 && (string.charAt(i) == '\'' || string.charAt(i) == '\"')) continue;
            sw.write(string.charAt(i));
        }
        return sw.toString();
    }

    public static Writer JsonQuote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block9;
                }
                case '\b': {
                    w.write("\\b");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        continue block9;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
        return w;
    }

    public static String XmlNodeNameEscape(String string) {
        return string.replaceAll("[^a-zA-Z0-9_]", "");
    }

    public static boolean IsWellFormedUriString(String url) {
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("//");
    }

    public static boolean IsNumeric(String str) {
        DecimalFormatSymbols currentLocaleSymbols = DecimalFormatSymbols.getInstance();
        char localeMinusSign = currentLocaleSymbols.getMinusSign();
        if (!Character.isDigit(str.charAt(0)) && str.charAt(0) != localeMinusSign) {
            return false;
        }
        boolean isDecimalSeparatorFound = false;
        char localeDecimalSeparator = currentLocaleSymbols.getDecimalSeparator();
        for (char c : str.substring(1).toCharArray()) {
            if (Character.isDigit(c)) continue;
            if (c == localeDecimalSeparator && !isDecimalSeparatorFound) {
                isDecimalSeparatorFound = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public static String CapitalizeFirstLetter(String letter) {
        if (letter.length() == 0) {
            return letter;
        }
        return letter.substring(0, 1).toUpperCase() + letter.substring(1);
    }

    public static String IfNULLOrEmpty(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (StringExtension.IsNullOrEmpty(args[i])) continue;
            return args[i].toString();
        }
        return null;
    }

    public static String[] FindReplacement(String input) {
        if (!StringExtension.IsNullOrEmpty(input) && StringExtension.HasReplacement(input)) {
            HashMap<String, Integer> output = new HashMap<String, Integer>();
            Matcher m = regexReplacePattern.matcher(input);
            while (m.find()) {
                String item = m.group();
                String key = StringExtension.removeWrapper(item);
                output.put(key, 1);
            }
            if (output.size() > 0) {
                String[] keyList = new String[output.size()];
                return output.keySet().toArray(keyList);
            }
        }
        return null;
    }

    public static boolean HasReplacement(String input) {
        return input.contains("{") && input.contains("}");
    }

    private static String removeWrapper(String key) {
        if (key.startsWith("{") && key.endsWith("}")) {
            return key.substring(1, key.length() - 1);
        }
        return key;
    }

    public static String ReplaceAll(String input, String pattern, String replacement) {
        String replaceString = "(?i)" + Pattern.quote("{" + pattern + "}");
        replacement = replacement.replace("\\", "\\\\");
        return input.replaceAll(replaceString, replacement);
    }
}

