/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Init.Extensions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.xml.bind.DatatypeConverter;

public class SecurityExtension {
    static final String defaultEncryptionSchema = "DESede";
    public static final String ALGORITHM = "RSA";

    public static String DESEncrypt(String input, String encryptionKey) {
        return SecurityExtension.DESEncrypt(defaultEncryptionSchema, input, encryptionKey, "UTF-8");
    }

    public static String DESEncrypt(String encryptionSchema, String input, String encryptionKey, String encoding) {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(encryptionSchema);
            byte[] arrayBytes = encryptionKey.getBytes(encoding);
            DESedeKeySpec ks = new DESedeKeySpec(arrayBytes);
            SecretKey key = skf.generateSecret(ks);
            Cipher cipher = Cipher.getInstance(encryptionSchema);
            cipher.init(1, key);
            byte[] plainText = input.getBytes(encoding);
            byte[] encryptedText = cipher.doFinal(plainText);
            return DatatypeConverter.printBase64Binary((byte[])encryptedText);
        }
        catch (Exception e) {
            e.printStackTrace();
            return input;
        }
    }

    public static String DESDecrypt(String input, String encryptionKey) {
        return SecurityExtension.DESDecrypt(defaultEncryptionSchema, input, encryptionKey, "UTF-8");
    }

    public static String DESDecrypt(String encryptionSchema, String input, String encryptionKey, String encoding) {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(encryptionSchema);
            byte[] arrayBytes = encryptionKey.getBytes(encoding);
            DESedeKeySpec ks = new DESedeKeySpec(arrayBytes);
            SecretKey key = skf.generateSecret(ks);
            Cipher cipher = Cipher.getInstance(encryptionSchema);
            cipher.init(2, key);
            byte[] encryptedText = DatatypeConverter.parseBase64Binary((String)input);
            byte[] plainText = cipher.doFinal(encryptedText);
            return new String(plainText, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return input;
        }
    }

    public static void RSAGenerateKey(int keySize, File privateKeyFile, File publicKeyFile) throws NoSuchAlgorithmException, IOException {
        RSAKey key = SecurityExtension.RSAGenerateKey(keySize);
        try (ObjectOutputStream publicKeyOS = new ObjectOutputStream(new FileOutputStream(publicKeyFile));){
            publicKeyOS.writeObject(key.getPublicKey());
        }
        var5_5 = null;
        try (ObjectOutputStream privateKeyOS = new ObjectOutputStream(new FileOutputStream(privateKeyFile));){
            privateKeyOS.writeObject(key.getPrivateKey());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    public static RSAKey RSAGenerateKey(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(ALGORITHM);
        generator.initialize(keySize);
        KeyPair pair = generator.generateKeyPair();
        return new RSAKey(pair.getPublic(), pair.getPrivate());
    }

    public static PublicKey RSAGetPublicKey(byte[] publicKeyBinary) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKeyBinary);
        KeyFactory keyFact = KeyFactory.getInstance(ALGORITHM);
        return keyFact.generatePublic(x509KeySpec);
    }

    public static PublicKey RSAGetPublicKey(File publicKeyFile) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, ClassNotFoundException {
        ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(publicKeyFile));
        return (PublicKey)inputStream.readObject();
    }

    public static PublicKey getPublicKeyFromBase64(String base64PublicKeyFile) throws IOException, ClassNotFoundException, InvalidKeySpecException, NoSuchAlgorithmException {
        return SecurityExtension.RSAGetPublicKey(DatatypeConverter.parseBase64Binary((String)base64PublicKeyFile));
    }

    public static PublicKey getPublicKeyFromHex(String hexPublicKey) throws IOException, ClassNotFoundException, InvalidKeySpecException, NoSuchAlgorithmException {
        return SecurityExtension.RSAGetPublicKey(DatatypeConverter.parseHexBinary((String)hexPublicKey));
    }

    public static Ciphertext RSAEncrypt(String text, PublicKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException {
        return SecurityExtension.RSAEncrypt(text.getBytes("UTF-8"), key);
    }

    public static Ciphertext RSAEncrypt(byte[] text, PublicKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, key);
        return new Ciphertext(cipher.doFinal(text));
    }

    public static PrivateKey RSAGetPrivateKey(File privateKeyFile) throws IOException, ClassNotFoundException {
        ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(privateKeyFile));
        return (PrivateKey)inputStream.readObject();
    }

    public static PrivateKey RSAGetPrivateKey(byte[] privateKeyBinary) throws IOException, ClassNotFoundException, InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec x509KeySpec = new PKCS8EncodedKeySpec(privateKeyBinary);
        KeyFactory keyFact = KeyFactory.getInstance(ALGORITHM);
        return keyFact.generatePrivate(x509KeySpec);
    }

    public static PrivateKey RSAGetPrivateKeyFromBase64(String base64PrivateKey) throws IOException, ClassNotFoundException, InvalidKeySpecException, NoSuchAlgorithmException {
        return SecurityExtension.RSAGetPrivateKey(DatatypeConverter.parseBase64Binary((String)base64PrivateKey));
    }

    public static PrivateKey RSAGetPrivateKeyFromHex(String hexPrivateKey) throws IOException, ClassNotFoundException, InvalidKeySpecException, NoSuchAlgorithmException {
        return SecurityExtension.RSAGetPrivateKey(DatatypeConverter.parseHexBinary((String)hexPrivateKey));
    }

    public static String RSADecryptFromBase64(String base64Text, PrivateKey key) throws UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return SecurityExtension.RSADecrypt(DatatypeConverter.parseBase64Binary((String)base64Text), key);
    }

    public static String RSADecryptFromHex(String hexText, PrivateKey key) throws UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return SecurityExtension.RSADecrypt(DatatypeConverter.parseHexBinary((String)hexText), key);
    }

    public static String RSADecrypt(byte[] text, PrivateKey key) throws UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, key);
        return new String(cipher.doFinal(text), "UTF-8");
    }

    public static String RSADecrypt(BigInteger text, PrivateKey key) throws UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, key);
        return new String(cipher.doFinal(text.toByteArray()), "UTF-8");
    }

    public static class Ciphertext {
        private byte[] encrypt;

        public byte[] getEncrypt() {
            return this.encrypt;
        }

        public String getBase64Text() {
            return DatatypeConverter.printBase64Binary((byte[])this.encrypt);
        }

        public String getHexText() {
            return DatatypeConverter.printHexBinary((byte[])this.encrypt);
        }

        public Ciphertext(byte[] encrypt) {
            this.encrypt = encrypt;
        }

        public String toString() {
            return "Base64:" + this.getBase64Text() + System.lineSeparator() + "Hex:" + this.getHexText() + System.lineSeparator();
        }
    }

    public static class RSAKey {
        private PublicKey publicKey;
        private PrivateKey privateKey;

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public RSAKey(PublicKey publicKey, PrivateKey privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public String getBase64PublicKey() {
            return DatatypeConverter.printBase64Binary((byte[])this.publicKey.getEncoded());
        }

        public String getBase64PrivateKey() {
            return DatatypeConverter.printBase64Binary((byte[])this.privateKey.getEncoded());
        }

        public String getHexPublicKey() {
            return DatatypeConverter.printHexBinary((byte[])this.publicKey.getEncoded());
        }

        public String getHexPrivateKey() {
            return DatatypeConverter.printHexBinary((byte[])this.privateKey.getEncoded());
        }

        public String getModulusPublicKey() {
            try {
                RSAPublicKeySpec pub = KeyFactory.getInstance(SecurityExtension.ALGORITHM).getKeySpec(this.getPublicKey(), RSAPublicKeySpec.class);
                return pub.getModulus().toString(16);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "Base64 Public Key:" + this.getBase64PublicKey() + System.lineSeparator() + "Base64 Private Key:" + this.getBase64PrivateKey() + System.lineSeparator() + "Hex Public Key:" + this.getHexPublicKey() + System.lineSeparator() + "Hex Private Key:" + this.getHexPrivateKey() + System.lineSeparator() + "Modulus Public Key:" + this.getModulusPublicKey() + System.lineSeparator();
        }
    }
}

