/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.WebClient;

import LinkFuture.Core.WebClient.AuthType;
import LinkFuture.Core.WebClient.FormContentTypes;
import LinkFuture.Core.WebClient.GroupAuthenticator;
import LinkFuture.Core.WebClient.HttpMethod;
import LinkFuture.Core.WebClient.WebClientInterruptThread;
import LinkFuture.Core.WebClient.WebClientResultInfo;
import LinkFuture.Core.WebClient.WebRequestFileInfo;
import LinkFuture.Core.WebClient.WebRequestInfo;
import LinkFuture.Init.Config;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import LinkFuture.Init.Utility;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.ws.WebServiceException;
import sun.net.www.MessageHeader;

public class WebClient {
    private static Field requestField;
    private static Field requestKeysField;
    private static Field requestValuesField;
    private static final String AuthorizationHeader = "Authorization";
    private static final int MaxRedirection = 10;
    private static final GroupAuthenticator GlobalAuthenticator;
    HttpURLConnection con = null;
    public volatile boolean isConnected = false;
    private DataOutputStream outputStream = null;
    private Thread interruptURLThread = null;
    private WebRequestInfo requestMeta;
    private static final String boundary = "7ddd51836076e";
    private static final String twoHyphens = "--";
    private static final String crlf = "\r\n";
    private static final String fieldSeperated = "--7ddd51836076e\r\n";

    private static synchronized void AppendCookie() {
        boolean enableCookie = ConfigurationController.AppSettings("EnableCookie").equalsIgnoreCase("true");
        if (enableCookie) {
            CookieManager cm = new CookieManager();
            cm.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(cm);
        }
    }

    private static synchronized void AppendAuthentication(String host) {
        if (Authenticator.requestPasswordAuthentication(host, null, 80, "", "", "", null, Authenticator.RequestorType.SERVER) == null) {
            Debugger.LogFactory.trace("Append global authentication");
            Authenticator.setDefault(GlobalAuthenticator);
        }
    }

    private static synchronized void AllowHttpsConnection() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (Exception ex) {
            Debugger.LogFactory.warn("Allow HttpsConnection", (Throwable)ex);
        }
    }

    private WebClient(WebRequestInfo requestMeta) {
        this.requestMeta = requestMeta;
    }

    private WebClientResultInfo Send() {
        WebClientResultInfo result;
        block10: {
            result = new WebClientResultInfo();
            try {
                this.connect(this.requestMeta.RequestURL);
                result.code = this.con.getResponseCode();
                result.errorMessage = this.con.getResponseMessage();
                if (this.requestMeta.AutoRedirect) {
                    int redirectCount = 0;
                    while (result.code == 302 || result.code == 301 || result.code == 303) {
                        String newUrl = this.con.getHeaderField("Location");
                        this.close();
                        Debugger.LogFactory.trace("Redirect to {}", (Object)newUrl);
                        this.connect(new URL(newUrl));
                        result.code = this.con.getResponseCode();
                        result.errorMessage = this.con.getResponseMessage();
                        if (++redirectCount <= 10) continue;
                        throw new WebServiceException("Reached max redirection times,10");
                    }
                }
                InputStream replyStream = null;
                boolean isSuccess = result.code >= 200 && result.code < 300;
                replyStream = isSuccess ? this.con.getInputStream() : this.con.getErrorStream();
                String contentEncodingField = this.con.getContentEncoding();
                result.HeaderFields = new HashMap();
                for (Map.Entry<String, List<String>> header : this.con.getHeaderFields().entrySet()) {
                    result.HeaderFields.put(header.getKey(), header.getValue().toString());
                }
                if (replyStream != null) {
                    InputStreamReader inputStreamReader;
                    String charset = this.getCharset();
                    if (contentEncodingField != null && contentEncodingField.equalsIgnoreCase("gzip")) {
                        GZIPInputStream gzipInputStream = new GZIPInputStream(replyStream);
                        inputStreamReader = new InputStreamReader((InputStream)gzipInputStream, charset);
                    } else {
                        inputStreamReader = new InputStreamReader(replyStream, charset);
                    }
                    result.response = Utility.read(inputStreamReader);
                } else {
                    result.response = "";
                }
                result.success = isSuccess;
            }
            catch (Exception e) {
                Debugger.fatal("Web client exception", e);
                if (result.code == 0) {
                    result.code = 500;
                }
                result.errorMessage = this.isConnected ? e.toString() : "java.net.SocketTimeoutException: Timed out";
                if (!StringExtension.IsNullOrEmpty(result.errorMessage)) break block10;
                String error = Debugger.getDetail(e);
                result.errorMessage = error.substring(0, error.indexOf(Config.NewLine));
            }
        }
        this.close();
        return result;
    }

    private String getCharset() {
        String contentType = this.con.getContentType();
        if (contentType == null) {
            return "UTF-8";
        }
        String[] values = contentType.split(";");
        String charset = null;
        for (String value : values) {
            if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
            charset = value.split("=", 2)[1];
        }
        return StringExtension.IsNullOrEmpty(charset) ? "UTF-8" : charset;
    }

    private void connect(URL url) throws IOException {
        this.isConnected = true;
        this.con = (HttpURLConnection)url.openConnection();
        if (this.requestMeta.ReadTimeout > 0) {
            this.con.setReadTimeout(this.requestMeta.ReadTimeout);
        }
        if (this.requestMeta.ConnectionTimeout > 0) {
            this.con.setConnectTimeout(this.requestMeta.ConnectionTimeout);
        }
        this.registerAuthentication();
        if (this.requestMeta.RequestHeadList != null) {
            for (Map.Entry<String, Object> item : this.requestMeta.RequestHeadList.entrySet()) {
                this.con.setRequestProperty(item.getKey(), item.getValue().toString());
            }
        }
        if (this.requestMeta.ReadTimeout > 0 || this.requestMeta.ConnectionTimeout > 0) {
            this.interruptURLThread = new Thread(new WebClientInterruptThread(this));
            this.interruptURLThread.start();
        }
        this.writeBytes();
    }

    private void registerAuthentication() {
        if (this.requestMeta.Credential != null) {
            String host = this.requestMeta.RequestURL.getHost();
            String ticket = GroupAuthenticator.RegisterAuthentication(host, this.requestMeta.Credential);
            WebClient.AppendAuthentication(host);
            if (!StringExtension.IsNullOrEmpty(ticket) && !this.requestMeta.RequestHeadList.containsKey(AuthorizationHeader)) {
                this.requestMeta.addHead(AuthorizationHeader, ticket);
            }
        }
    }

    private void savingAuthorizationHeader() {
        block7: {
            if (this.requestMeta.Credential != null && this.requestMeta.Credential.RequestAuthType == AuthType.Digest) {
                try {
                    if (requestField == null) {
                        try {
                            requestField = this.con.getClass().getDeclaredField("requests");
                            requestField.setAccessible(true);
                            Class<MessageHeader> message = MessageHeader.class;
                            requestKeysField = message.getDeclaredField("keys");
                            requestKeysField.setAccessible(true);
                            requestValuesField = message.getDeclaredField("values");
                            requestValuesField.setAccessible(true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (requestField == null || requestKeysField == null || requestValuesField == null) break block7;
                    MessageHeader requestHeader = (MessageHeader)requestField.get(this.con);
                    String[] keys = (String[])requestKeysField.get(requestHeader);
                    String host = this.requestMeta.RequestURL.getHost();
                    for (int i = 0; i < keys.length; ++i) {
                        if (keys[i] == null || !keys[i].equalsIgnoreCase(AuthorizationHeader)) continue;
                        String[] values = (String[])requestValuesField.get(requestHeader);
                        GroupAuthenticator.SetAuthorizationTicket(host, values[i]);
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void close() {
        if (this.interruptURLThread != null) {
            this.interruptURLThread.interrupt();
            this.interruptURLThread = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.outputStream = null;
        }
        if (this.con != null) {
            this.isConnected = false;
            this.con.disconnect();
            this.con = null;
        }
    }

    private String buildFormPostString() throws UnsupportedEncodingException {
        if (this.requestMeta.PostStringList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> item : this.requestMeta.PostStringList.entrySet()) {
                sb.append(fieldSeperated);
                sb.append("Content-Disposition: form-data; name=\"" + item.getKey() + "\"");
                sb.append(crlf);
                sb.append(crlf);
                sb.append(item.getValue());
                sb.append(crlf);
            }
            return sb.toString();
        }
        return null;
    }

    private String buildUrlEncodingPostString() throws UnsupportedEncodingException {
        if (this.requestMeta.PostStringList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Map.Entry<String, Object> item : this.requestMeta.PostStringList.entrySet()) {
                sb.append(String.format("%s=%s", item.getKey(), URLEncoder.encode(item.getValue().toString(), "UTF-8")));
                if (++i >= this.requestMeta.PostStringList.size()) continue;
                sb.append("&");
            }
            return sb.toString();
        }
        return null;
    }

    private void writeBytes() throws IOException {
        switch (this.requestMeta.RequestMethod) {
            case Get: 
            case Delete: {
                this.con.setRequestMethod(this.requestMeta.RequestMethod.toString().toUpperCase());
                this.con.setUseCaches(this.requestMeta.UseCaches);
                Debugger.LogFactory.trace("{} data from {}", (Object)this.requestMeta.RequestMethod, (Object)this.requestMeta.RequestURL);
                break;
            }
            case Post: 
            case Put: {
                boolean hasPostFile;
                this.con.setRequestMethod(this.requestMeta.RequestMethod.toString().toUpperCase());
                this.con.setUseCaches(false);
                this.con.setRequestProperty("Cache-Control", "no-cache");
                boolean hasPayload = !StringExtension.IsNullOrEmpty(this.requestMeta.Payload);
                boolean hasPostData = this.requestMeta.PostStringList != null && this.requestMeta.PostStringList.size() > 0 || hasPayload;
                boolean bl = hasPostFile = this.requestMeta.PostFileList != null && this.requestMeta.PostFileList.size() > 0;
                if (hasPostData || hasPostFile) {
                    this.con.setDoOutput(true);
                    this.con.setDoInput(true);
                    if (hasPostData && !hasPostFile && this.requestMeta.EncType == FormContentTypes.UrlEncoded) {
                        byte[] postString = null;
                        if (hasPayload) {
                            postString = this.requestMeta.Payload.getBytes("UTF-8");
                        } else {
                            this.con.setRequestProperty("Content-Type", FormContentTypes.UrlEncoded.toString());
                            postString = this.buildUrlEncodingPostString().getBytes("UTF-8");
                        }
                        this.con.setRequestProperty("Content-Length", String.valueOf(postString.length));
                        this.outputStream = new DataOutputStream(this.con.getOutputStream());
                        this.outputStream.write(postString);
                    } else {
                        this.con.setRequestProperty("Content-Type", FormContentTypes.FormData.toString().concat(";boundary=7ddd51836076e"));
                        this.outputStream = new DataOutputStream(this.con.getOutputStream());
                        if (hasPostData) {
                            this.outputStream.writeBytes(this.buildFormPostString());
                        }
                        for (Map.Entry<String, WebRequestFileInfo> item : this.requestMeta.PostFileList.entrySet()) {
                            int nRead;
                            WebRequestFileInfo fileInfo = item.getValue();
                            this.outputStream.writeBytes(fieldSeperated);
                            this.outputStream.writeBytes("Content-Disposition:form-data;name=\"" + fileInfo.Name + "\";filename=\"" + fileInfo.FileName + "\"" + crlf);
                            if (StringExtension.IsNullOrEmpty(fileInfo.ContentType)) {
                                this.outputStream.writeBytes("Content-Type: application/octet-stream");
                            } else {
                                this.outputStream.writeBytes("Content-Type: " + fileInfo.ContentType);
                            }
                            this.outputStream.writeBytes("\r\nContent-Transfer-Encoding: binary");
                            this.outputStream.writeBytes(crlf);
                            this.outputStream.writeBytes(crlf);
                            byte[] data = new byte[1024];
                            while ((nRead = fileInfo.FileStream.read(data, 0, data.length)) != -1) {
                                this.outputStream.write(data, 0, nRead);
                            }
                            this.outputStream.writeBytes(crlf);
                        }
                        this.outputStream.writeBytes("--7ddd51836076e--\r\n");
                    }
                } else {
                    throw new IllegalArgumentException("Must append data to post");
                }
                this.outputStream.flush();
                Debugger.LogFactory.trace("{} data to {}", (Object)this.requestMeta.RequestMethod, (Object)this.requestMeta.RequestURL);
            }
        }
    }

    public static WebClientResultInfo sendRequest(WebRequestInfo requestMeta) {
        WebClient client = new WebClient(requestMeta);
        return client.Send();
    }

    public static WebClientResultInfo sendRequest(WebRequestInfo requestMeta, int retryTimes) {
        if (retryTimes < 1) {
            retryTimes = 1;
        }
        WebClientResultInfo result = null;
        for (int i = 0; i < retryTimes; ++i) {
            result = WebClient.sendRequest(requestMeta);
            if (!result.success) continue;
            return result;
        }
        return result;
    }

    public static WebClientResultInfo sendRequest(URL url, HttpMethod method, ArrayList<NameValuePair> postData) throws UnsupportedEncodingException {
        WebRequestInfo requestMeta = new WebRequestInfo();
        requestMeta.RequestURL = url;
        requestMeta.RequestMethod = method;
        if (requestMeta.RequestMethod == HttpMethod.Post && postData != null) {
            for (NameValuePair item : postData) {
                requestMeta.addPostData(item.id, item.value);
            }
        }
        return WebClient.sendRequest(requestMeta);
    }

    public static WebClientResultInfo sendRequest(String url, HttpMethod method, ArrayList<NameValuePair> postData) throws UnsupportedEncodingException, MalformedURLException {
        return WebClient.sendRequest(WebClient.BuildUrl(url), method, postData);
    }

    public static WebClientResultInfo post(URL url, ArrayList<NameValuePair> postData) throws UnsupportedEncodingException {
        return WebClient.sendRequest(url, HttpMethod.Post, postData);
    }

    public static WebClientResultInfo post(String url, ArrayList<NameValuePair> postData) throws UnsupportedEncodingException, MalformedURLException {
        return WebClient.sendRequest(WebClient.BuildUrl(url), HttpMethod.Post, postData);
    }

    private static URL BuildUrl(String url) throws MalformedURLException {
        if (url.startsWith("//")) {
            url = "http:" + url;
        }
        return new URL(url);
    }

    public static WebClientResultInfo get(String url) throws MalformedURLException {
        return WebClient.get(WebClient.BuildUrl(url));
    }

    public static WebClientResultInfo get(URL url) {
        WebRequestInfo requestMeta = new WebRequestInfo();
        requestMeta.RequestURL = url;
        requestMeta.RequestMethod = HttpMethod.Get;
        return WebClient.sendRequest(requestMeta);
    }

    static {
        GlobalAuthenticator = new GroupAuthenticator();
        WebClient.AllowHttpsConnection();
        WebClient.AppendCookie();
    }
}

