/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.MemoryManager.StaticMemoryCache;

import LinkFuture.Core.MemoryManager.Meta.MemoryInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryMetaInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryType;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryInfo;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StaticMemoryHelper {
    private static final Map<String, StaticMemoryInfo> cachedObject = new ConcurrentHashMap<String, StaticMemoryInfo>();
    private static long lastClearTime = 0L;
    private static final long clearUpInterval = 300000L;

    public static <T> MemoryInfo<T> addNeverExpiredMemoryCache(String key, Operation operation) throws Exception {
        MemoryMetaInfo meta = new MemoryMetaInfo();
        meta.CacheType = MemoryType.Never;
        meta.Key = key;
        meta.Enable = true;
        meta.Action = operation;
        return StaticMemoryHelper.addMemoryCache(meta);
    }

    public static <T> MemoryInfo<T> addMemoryCache(MemoryMetaInfo meta) throws Exception {
        if (!meta.Enable) {
            Debugger.LogFactory.trace("this cache setting({}) has been disabled, call it directly ", (Object)meta.Key);
            MemoryInfo output = new MemoryInfo();
            output.meta = meta;
            output.cachedObject = meta.Action.call();
            return output;
        }
        if (!cachedObject.containsKey(meta.getUniqueKey())) {
            Debugger.LogFactory.trace("add memory into local({}) for key {}", (Object)meta.CacheType, (Object)meta.Key);
            StaticMemoryHelper.runAction(meta, System.currentTimeMillis());
        }
        return StaticMemoryHelper.getMemory(meta);
    }

    public static void clear(MemoryMetaInfo meta) {
        if (cachedObject.containsKey(meta.getUniqueKey())) {
            Debugger.LogFactory.trace("removing {}", (Object)meta.getUniqueKey());
            cachedObject.remove(meta.getUniqueKey());
        }
    }

    public static void refresh() {
        Debugger.LogFactory.warn("refresh memory");
        for (StaticMemoryInfo memory : cachedObject.values()) {
            if (memory.meta.CacheType != MemoryType.Absolute || !memory.hasExpired()) continue;
            Debugger.LogFactory.trace("this memory({}) has been expired", (Object)memory.meta.Key);
            StaticMemoryHelper.clear(memory.meta);
        }
    }

    private static synchronized void refreshByTime() {
        new Thread(() -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime > lastClearTime + 300000L) {
                lastClearTime = currentTime;
                StaticMemoryHelper.refresh();
            }
        }).start();
    }

    public static <T> MemoryInfo<T> getMemory(MemoryMetaInfo meta) {
        long currentTime = System.currentTimeMillis();
        String key = meta.getUniqueKey();
        if (cachedObject.containsKey(key)) {
            StaticMemoryInfo cacheInfo = cachedObject.get(key);
            if (!cacheInfo.meta.Enable) {
                cachedObject.remove(key);
                return null;
            }
            switch (cacheInfo.meta.CacheType) {
                case Never: {
                    Debugger.LogFactory.trace("load memory from local({}) for key {}", (Object)meta.CacheType, (Object)meta.Key);
                    return cacheInfo.getMemoryInfo(cacheInfo.cachedObject);
                }
                case Absolute: {
                    if (!cacheInfo.hasExpired()) {
                        Debugger.LogFactory.trace("load memory from local({}) for key {}", (Object)meta.CacheType, (Object)meta.Key);
                        return cacheInfo.getMemoryInfo(cacheInfo.cachedObject);
                    }
                    if (cacheInfo.meta.AutoRefresh) {
                        try {
                            Debugger.LogFactory.trace("renewing memory from local({}) for key {}", (Object)meta.CacheType, (Object)meta.Key);
                            StaticMemoryHelper.runAction(cacheInfo.meta, currentTime);
                            return cacheInfo.getMemoryInfo(cacheInfo.cachedObject);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e.getMessage());
                        }
                    }
                    cachedObject.remove(key);
                    return null;
                }
            }
        }
        StaticMemoryHelper.refreshByTime();
        return null;
    }

    public static <T> MemoryInfo<T> getMemory(String key) {
        MemoryMetaInfo meta = new MemoryMetaInfo();
        meta.Key = key;
        return StaticMemoryHelper.getMemory(meta);
    }

    private static void runAction(MemoryMetaInfo meta, long currentTime) throws Exception {
        StaticMemoryInfo memory = new StaticMemoryInfo();
        memory.cachedObject = meta.Action.call();
        memory.cachedTime = currentTime;
        memory.meta = meta;
        if (meta.CacheType == MemoryType.Absolute) {
            memory.expiredTime = currentTime + meta.getTimeSpan().getTimeStamp();
        }
        cachedObject.put(meta.getUniqueKey(), memory);
        StaticMemoryHelper.refreshByTime();
    }

    public static String getMemoryStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("<MemoryController>");
        for (StaticMemoryInfo memory : cachedObject.values()) {
            sb.append(memory.toString());
        }
        sb.append("</MemoryController>");
        return sb.toString();
    }

    public static void destroy() {
        Debugger.LogFactory.trace("destroy all");
        cachedObject.clear();
    }
}

