/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.GenericRepository.Repository;

import LinkFuture.Core.ContentManager.ContentController;
import LinkFuture.Core.ContentManager.Model.ContentResultCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.ContentManager.Model.ContentType;
import LinkFuture.Core.ContentManager.Model.LoadContentInfo;
import LinkFuture.Core.ContentManager.Model.ResponseType;
import LinkFuture.Core.GenericRepository.Repository.BaseRepository;
import LinkFuture.Core.GenericRepository.Repository.IGenericRepository;
import LinkFuture.Core.Utility;
import LinkFuture.Core.WebClient.HttpMethod;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class GenericRepository<T, ID extends Serializable>
extends BaseRepository<T, ID>
implements IGenericRepository<T, ID> {
    public GenericRepository(String requestPath) {
        super(requestPath);
    }

    @Override
    protected <R> Object genericDBResourceLoad(String contentName, HttpMethod method, R requestObject, String cacheSetting) throws Exception {
        ContentResultCollectionInfo result;
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("LF_HttpMethod", (Object)method));
        list.add(new NameValuePair("LF_ResponseType", (Object)ResponseType.Json));
        switch (method) {
            case Get: 
            case Delete: {
                list.add(new NameValuePair("$JsonQuery", Utility.jacksonToJson(requestObject)));
                break;
            }
            case Post: 
            case Put: {
                list.add(new NameValuePair("LF_ContentType", (Object)ContentType.Json));
                list.add(new NameValuePair("LF_PlayLoad", Utility.jacksonToJson(requestObject)));
                break;
            }
            case Options: {
                break;
            }
            case Patch: {
                break;
            }
        }
        LoadContentInfo meta = new LoadContentInfo();
        meta.passedParam = list;
        meta.resourceOnly = false;
        meta.ignoreSecurity = true;
        if (!StringExtension.IsNullOrEmpty(cacheSetting)) {
            meta.cacheSetting = cacheSetting;
        }
        if ((result = ContentController.LoadContent(contentName, meta)).size() > 0) {
            ContentResultInfo myResult = (ContentResultInfo)result.get(0);
            if (myResult.Success) {
                logger.trace(myResult.Result == null ? "No result found" : myResult.Result.toString());
                return myResult.Result;
            }
        }
        throw new IllegalArgumentException("No result found");
    }
}

