/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.DBReader;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.DBTypeInfo;
import LinkFuture.Core.DBHelper.Model.FieldInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.SPParameterInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Init.Utility;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class DBBeanReader
extends DBReader {
    public DBBeanReader(Statement statement, SPInfo spMetaInfo) {
        super(statement, spMetaInfo);
    }

    public ArrayList<ArrayList<?>> Read(Class<?> ... outputType) throws Exception {
        if (this.DBType == DBTypeInfo.PostgreSQL && this.statement instanceof CallableStatement) {
            Connection conn = this.statement.getConnection();
            ArrayList result = new ArrayList();
            int resultIndex = 0;
            for (SPParameterInfo param : this.spMetaInfo.parameterList) {
                if (param.sqlTypes != 1111) continue;
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(String.format("FETCH ALL IN \"%s\"", param.parameterName));
                ArrayList<?> item = DBBeanReader.read(rs, outputType[resultIndex]);
                result.add(item);
                ++resultIndex;
            }
            return result;
        }
        ArrayList result = new ArrayList();
        int resultIndex = 0;
        boolean hadResults = true;
        while (hadResults) {
            ResultSet rs = this.statement.getResultSet();
            if (resultIndex < outputType.length) {
                ArrayList<?> item = DBBeanReader.read(rs, outputType[resultIndex]);
                result.add(item);
            }
            ++resultIndex;
            hadResults = this.statement.getMoreResults();
        }
        return result;
    }

    public static <T> ArrayList<T> read(ResultSet rs, Class<T> type) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        TableInfo resultMetaInfo = DBHelper.findResultsColumnInfo(rsmd);
        ArrayList<T> result = new ArrayList<T>();
        while (rs.next()) {
            T newRow = DBBeanReader.fillObject(rs, resultMetaInfo, type);
            result.add(newRow);
        }
        return result;
    }

    public static <T> T fillObject(ResultSet rs, TableInfo resultMetaInfo, Class<T> type) throws Exception {
        T newInstance = type.newInstance();
        HashMap<String, FieldInfo> fieldList = DBHelper.findClassFieldInfo(type);
        for (int i = 1; i <= resultMetaInfo.columnList.size(); ++i) {
            ColumnInfo column = resultMetaInfo.columnList.get(i - 1);
            String fieldKey = column.columnName.toLowerCase();
            if (!fieldList.containsKey(fieldKey)) continue;
            FieldInfo fieldMeta = fieldList.get(fieldKey);
            fieldMeta.field.setAccessible(true);
            Object objValue = rs.getObject(i);
            if (objValue == null) continue;
            Class<?> fieldType = fieldMeta.field.getType();
            fieldMeta.field.set(newInstance, Utility.cast(objValue, fieldType));
        }
        for (String fieldKey : fieldList.keySet()) {
            FieldInfo fieldMeta = fieldList.get(fieldKey);
            if (fieldMeta.columnAttribute == null || !fieldMeta.columnAttribute.isEntity()) continue;
            fieldMeta.field.setAccessible(true);
            Object subInstance = DBBeanReader.fillObject(rs, resultMetaInfo, fieldMeta.field.getType());
            fieldMeta.field.set(newInstance, subInstance);
        }
        return newInstance;
    }
}

