/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Core.ContentManager.Model.ContentImportFileInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ParameterInfo;
import LinkFuture.Core.ContentManager.Model.ProcessorInfo;
import LinkFuture.Core.ContentManager.Model.ResourceInfo;
import LinkFuture.Core.ContentManager.Model.SecurityInfo;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.JAXBCaseInsensitiveMapAdaptor;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="ContentConfiguration")
@XmlSeeAlso(value={ResourceInfo.class, SecurityInfo.class, ParameterInfo.class, ContentItemInfo.class, ProcessorInfo.class, ContentImportFileInfo.class})
public class ContentConfigurationInfo {
    @XmlElement(name="Import")
    public List<ContentImportFileInfo> ImportList;
    @XmlElementWrapper(name="ContentItemList")
    @XmlElement(name="ContentItem")
    public List<ContentItemInfo> ContentItemList;
    @XmlElement(name="SecurityList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<SecurityInfo> SecurityList;
    @XmlElement(name="ParameterList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<ParameterInfo> ParameterList;
    @XmlElement(name="ResourceList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<ResourceInfo> ResourceList;
    @XmlElement(name="ProcessorList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<ProcessorInfo> ProcessorList;
    public Integer LatestVersion = Integer.MIN_VALUE;

    public ContentItemInfo FindContentItem(String name) {
        return this.FindContentItem(name, null);
    }

    public ContentItemInfo FindContentItem(String name, Integer version) {
        if (version != null && version > this.LatestVersion) {
            throw new IllegalArgumentException("Specific version does not exist:" + version);
        }
        if (this.ContentItemList != null) {
            ContentItemInfo latestVersion = null;
            ContentItemInfo closestVersion = null;
            for (ContentItemInfo item : this.ContentItemList) {
                if (!item.Name.equalsIgnoreCase(name) || item.Disabled) continue;
                if (version == null) {
                    if (latestVersion != null && latestVersion.Version >= item.Version) continue;
                    latestVersion = item;
                    continue;
                }
                if (item.Version.equals(version)) {
                    return item;
                }
                if (item.Version >= version || closestVersion != null && version - closestVersion.Version <= version - item.Version) continue;
                closestVersion = item;
            }
            if (version == null && latestVersion != null) {
                return latestVersion;
            }
            if (closestVersion != null) {
                return closestVersion;
            }
        }
        throw new IllegalArgumentException("Specific content item not found:" + name);
    }
}

