/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentSecurity;

import LinkFuture.Core.ContentManager.ContentSecurity.ContentBasicMetaInfo;
import LinkFuture.Core.ContentManager.ContentSecurity.ContentBeanBaseSecurity;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.SecurityInfo;
import LinkFuture.Init.Debugger;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.xml.bind.DatatypeConverter;

public class ContentBasicSecurity
extends ContentBeanBaseSecurity<ContentBasicMetaInfo> {
    public ContentBasicSecurity(SecurityInfo currentSecurity) throws Exception {
        super(currentSecurity, ContentBasicMetaInfo.class);
    }

    @Override
    public void Verify(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        block4: {
            Debugger.LogFactory.trace("Basic Authorization");
            if (parameters.containsKey("LF_Authorization")) {
                try {
                    String auth = (String)parameters.get("LF_Authorization");
                    if (!this.allowUser(auth)) {
                        Debugger.LogFactory.trace("Authorization token has been expired");
                        throw new SecurityException("Token has been expired");
                    }
                    break block4;
                }
                catch (Exception e) {
                    Debugger.fatal("Authorization failed", e);
                    throw new SecurityException("Authorization failed");
                }
            }
            Debugger.LogFactory.trace("Authorization failed");
            throw new SecurityException("Authorization failed");
        }
    }

    public boolean allowUser(String authHeader) throws UnsupportedEncodingException, NamingException {
        String credentials;
        String userPass;
        int separator;
        String basic;
        StringTokenizer st;
        if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic") && (separator = (userPass = new String(DatatypeConverter.parseBase64Binary((String)(credentials = st.nextToken())), "UTF-8")).indexOf(":")) != -1) {
            String inputUsername = userPass.substring(0, separator);
            String inputPassword = userPass.substring(separator + 1);
            return ((ContentBasicMetaInfo)this.Meta).UserName.equalsIgnoreCase(inputUsername) && ((ContentBasicMetaInfo)this.Meta).Password.equals(inputPassword);
        }
        return false;
    }
}

