package LinkFuture.Init;

import LinkFuture.Init.Extensions.PathExtension;
import org.apache.commons.beanutils.ConvertUtilsBean;

import java.io.*;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 11/22/13
 * Time: 11:55 AM
 * To change this template use File | Settings | File Templates.
 */
public class Utility {
    //region Find Field by annotation class
    private static Map<String,Field> neverExpiredFieldObject = new ConcurrentHashMap<>();
    public static<T extends Annotation> Field findField(Class<?> type,Class<T> annotationClass) throws Exception {
        String classKey = "$Utility$findField".concat(type.getName()).concat(annotationClass.getName());
        if(!neverExpiredFieldObject.containsKey(classKey))
        {
            neverExpiredFieldObject.put(classKey,findFieldEx(type,annotationClass));
        }
        return neverExpiredFieldObject.get(classKey);
    }
    private static<T extends Annotation> Field findFieldEx(Class<?> type,Class<T> annotationClass){
        for (Field field:type.getDeclaredFields())
        {
            if(field.getAnnotation(annotationClass)!=null)
            {
                return field;
            }
        }
        throw new IllegalArgumentException("Specific ".concat(type.getName()).concat(" must have annotation ").concat(annotationClass.getName()));
    }

    static final ConvertUtilsBean convertUtils = new ConvertUtilsBean();
    @SuppressWarnings("unchecked")
    public static <T> T cast(Object value,Class<T> fieldType)
    {
        if (fieldType==UUID.class)
        {
            return (T)UUID.fromString((String)value);
        }
        if(fieldType ==Boolean.class && value instanceof String)
        {
            return (T)(Object)(((String) value).equalsIgnoreCase("YES")
                    ||((String) value).equalsIgnoreCase("TRUE")
                    ||((String) value).equalsIgnoreCase("1"));
        }
        return (T)convertUtils.convert(value, fieldType);
    }
    //endregion

    //region File Operation

    /***
     * getStringFromFile
     * @param filePath  disk path or class path , i.e d:\file.txt or classpath:a.txt
     * @return content of file
     * @throws IOException
     */
    public static String getStringFromFile(String filePath) throws IOException {
        return getStringFromFile(filePath, Config.DefaultEncoding);
    }
    public static String getStringFromFile(String filePath,String encoding) throws IOException {
        return read(new InputStreamReader(getStreamFromFile(filePath), encoding));
    }
    public static InputStream getStreamFromFile(String filePath) throws FileNotFoundException {
        if(filePath.startsWith(Config.ClassPath))
        {
            Debugger.LogFactory.trace("Reading file: {}", filePath);
            filePath= filePath.substring(Config.ClassPath.length());
            return getResource(filePath);
        }
        else
        {
            String diskFilePath = PathExtension.FullPhysicalPath(filePath);
            Debugger.LogFactory.trace("Reading file: {}", diskFilePath);
            return new FileInputStream(diskFilePath);
        }
    }
    public static InputStream getResource(String resource){
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if(classLoader != null)
        {
            Debugger.LogFactory.debug("Trying to find [{}] using Thread.currentThread().getContextClassLoader.",resource);
            URL url =  classLoader.getResource(resource);
            if(url!=null)
            {
                return classLoader.getResourceAsStream(resource);
            }
        }
        classLoader = Utility.class.getClassLoader();
        if(classLoader != null) {
            Debugger.LogFactory.debug("Trying to find [{}] using Utility.class.getClassLoader.",resource );
            URL url =  classLoader.getResource(resource);
            if(url!=null)
            {
                return classLoader.getResourceAsStream(resource);
            }
        }
        URL url = ClassLoader.getSystemResource(resource);
        if(url!=null)
        {
            Debugger.LogFactory.debug("Trying to find [{}] using ClassLoader.getSystemResource().",resource );
            return ClassLoader.getSystemResourceAsStream(resource);
        }
        throw new IllegalArgumentException("Can't find file "+resource+" from class path");
    }

    public static boolean saveStringToFile(String filePath,String content,boolean isOverwrite) 	{
        Debugger.LogFactory.trace("Save {}",filePath);
        File file = new File(filePath);
        if(file.exists())
        {
            if(isOverwrite)
            {
                //noinspection ResultOfMethodCallIgnored
                file.delete();
            }
            else
            {
                return false;
            }
        }
        boolean saved = false;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file))){
            bufferedWriter.write(content);
            saved = true;
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        return saved;
    }
    @SuppressWarnings("UnusedDeclaration")
    public static byte[] getBytesFromFile(String filePath) throws FileNotFoundException {
        Debugger.LogFactory.trace("Reading file: {}",filePath);
        File file = new File(filePath);
        if(file.exists())
        {
            try(RandomAccessFile bufferedReader = new RandomAccessFile(filePath,"r")){
                long buffLength = bufferedReader.length();
                int length = (int) buffLength;
                if (length != buffLength)
                    throw new IOException("File size >= 2 GB");
                byte[] data = new byte[length];
                bufferedReader.readFully(data);
                bufferedReader.close();
                return data;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        throw new FileNotFoundException("Specific file not exist, " + filePath);
    }
    public static String read(InputStreamReader inputStreamReader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try(BufferedReader reader =  new BufferedReader(inputStreamReader))
        {
            String inputLine;
            while ((inputLine = reader.readLine()) != null) {
                sb.append(inputLine);
                sb.append(Config.NewLine);
            }
            reader.close();
        }
        return sb.toString();
    }
    public static String read(InputStream inputStream,String encoding) throws IOException {
        return read(new InputStreamReader(inputStream,encoding));
    }
    //endregion
}
