package LinkFuture.Init.ObjectExtend;

import java.util.ArrayList;

/**
 * LinkFuture.
 * User: Cyokin Zhang
 * Date: 12/27/13
 * Time: 1:43 PM
 */
public class NameListPair<T> {
    /**
     * The name to be associated with a value by this <code>NameValuePair</code> object.
     */
    public String id;

    /**
     * The value to be associated with a name by this <code>NameValuePair</code> object.
     */
    public ArrayList<T> values;

    public T getFirstValue(){
        if(values.size()>0)
        {
            return values.get(0);
        }
        return null;
    }

    /**
     * Constructs an empty <code>NameValuePair</code> object.
     * To associate a name with a value after using this constructor, the fields
     * of this object have to be accessed individually.
     */
    public NameListPair() {
        this.values = new ArrayList<>();
    }

    /**
     * Constructs a <code>NameValuePair</code> object that associates
     * the given name with the given <code>org.omg.CORBA.Any</code> object.
     * @param __id the name to be associated with the given <code>Any</code> object
     * @param __values the <code>Any</code> object to be associated with the given name
     */
    public NameListPair(String __id,   ArrayList<T> __values) {
        id = __id;
        values = __values;
    }
    public NameListPair(String __id,   T... __values) {
        this();
        id = __id;
        for (T item : __values)
        {
            this.values.add(item);
        }
    }
}
