package LinkFuture.Init.Extensions;

import LinkFuture.Init.Config;
import LinkFuture.Init.ObjectExtend.Callback;
import org.json.JSONObject;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 10/1/13
 * Time: 11:58 AM
 * To change this template use File | Settings | File Templates.
 */
public class StringExtension {
    public static String TrimStart(String input,String trimString)
    {
        if(input.startsWith(trimString))
        {
            return input.substring(trimString.length(),input.length());
        }
        return input;
    }
    public static String TrimEnd(String input,String trimString)
    {
        if(input.endsWith(trimString))
        {
            int index = input.length() - trimString.length();
            return input.substring(0,index);
        }
        return input;
    }
    public static boolean IsNullOrEmpty(Object str)
    {
        return str==null || str.toString().length()==0;
    }
    public static int Length(CharSequence str)
    {
        return (str == null) ? 0 : str.length();
    }
    public static boolean IsUrl(String url){
        try {
            URL u = new URL(url);   // this would check for the protocol
            u.toURI();     // does the extra checking required for validation of URI
            return true;
        } catch (Exception e) {
            //do nothing
        }
        return false;
    }

    public static String Join(Collection<?> s, String delimiter) {
        return Join(s,delimiter,null);
    }
    public static String Join(Collection<?> s, String delimiter,Callback<String,String> fun) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> item = s.iterator();
        while (item.hasNext()) {
            builder.append(item.next());
            if (!item.hasNext()) {
                break;
            }
            if(fun!=null)
            {
                builder.append(fun.call(delimiter));
            }
            else
            {
                builder.append(delimiter);
            }
        }
        return builder.toString();
    }

    /**
     * Replace special characters with XML escapes:
     * <pre>
     * &amp; <small>(ampersand)</small> is replaced by &amp;amp;
     * &lt; <small>(less than)</small> is replaced by &amp;lt;
     * &gt; <small>(greater than)</small> is replaced by &amp;gt;
     * &quot; <small>(double quote)</small> is replaced by &amp;quot;
     * </pre>
     * @param string The string to be escaped.
     * @return The escaped string.
     */
    public static String XmlEscape(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0, length = string.length(); i < length; i++) {
            char c = string.charAt(i);
            switch (c) {
                case '&':
                    sb.append("&amp;");
                    break;
                case '<':
                    sb.append("&lt;");
                    break;
                case '>':
                    sb.append("&gt;");
                    break;
                case '"':
                    sb.append("&quot;");
                    break;
                case '\'':
                    sb.append("&apos;");
                    break;
                default:
                    sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String JsonQuote(String string) {
        StringWriter sw = new StringWriter();
        synchronized (sw.getBuffer()) {
            try {
                return JsonQuote(string, sw).toString();
            } catch (IOException ignored) {
                // will never happen - we are writing to a string writer
                return "";
            }
        }
    }
    public static String JsonDeQuote(String string)
    {
        JSONObject obj= new JSONObject("{\"a\":" + string + "}");
        return obj.getString("a");
    }
    public static String removeQuote(String string){
        StringWriter sw = new StringWriter();
        int len = string.length();
        for (int i = 0; i < len; i += 1) {
            if (i ==0 && (string.charAt(i)=='\'' || string.charAt(i)=='"'))
            {
                continue;
            }
            if (i ==len-1 && (string.charAt(i)=='\'' || string.charAt(i)=='"'))
            {
                continue;
            }
            sw.write(string.charAt(i));
        }
        return sw.toString();
    }

    public static Writer JsonQuote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }

        char b;
        char c = 0;
        String hhhh;
        int i;
        int len = string.length();

        w.write('"');
        for (i = 0; i < len; i += 1) {
            b = c;
            c = string.charAt(i);
            switch (c) {
                case '\\':
                case '"':
                    w.write('\\');
                    w.write(c);
                    break;
                case '/':
                    if (b == '<') {
                        w.write('\\');
                    }
                    w.write(c);
                    break;
                case '\b':
                    w.write("\\b");
                    break;
                case '\t':
                    w.write("\\t");
                    break;
                case '\n':
                    w.write("\\n");
                    break;
                case '\f':
                    w.write("\\f");
                    break;
                case '\r':
                    w.write("\\r");
                    break;
                default:
                    if (c < ' ' || (c >= '\u0080' && c < '\u00a0')
                            || (c >= '\u2000' && c < '\u2100')) {
                        w.write("\\u");
                        hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                    } else {
                        w.write(c);
                    }
            }
        }
        w.write('"');
        return w;
    }

    public static String XmlNodeNameEscape(String string) {
        return string.replaceAll("[^a-zA-Z0-9_]", Config.Empty);
    }

    public static boolean IsWellFormedUriString(String url)   {
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("//");
    }

    public static boolean IsNumeric( String str )
    {
        DecimalFormatSymbols currentLocaleSymbols = DecimalFormatSymbols.getInstance();
        char localeMinusSign = currentLocaleSymbols.getMinusSign();

        if ( !Character.isDigit( str.charAt( 0 ) ) && str.charAt( 0 ) != localeMinusSign ) return false;

        boolean isDecimalSeparatorFound = false;
        char localeDecimalSeparator = currentLocaleSymbols.getDecimalSeparator();

        for ( char c : str.substring( 1 ).toCharArray() )
        {
            if ( !Character.isDigit( c ) )
            {
                if ( c == localeDecimalSeparator && !isDecimalSeparatorFound )
                {
                    isDecimalSeparatorFound = true;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public static String CapitalizeFirstLetter(String letter){
        if(letter.length() == 0)
            return letter;
        return letter.substring(0, 1).toUpperCase() + letter.substring(1);
    }

    public static String IfNULLOrEmpty(Object ... args)
    {
        for (int i = 0; i < args.length; i++) {
            if(!StringExtension.IsNullOrEmpty(args[i]))
            {
                return args[i].toString();
            }
        }
        return null;
    }

    //region FindReplacement
    /**
     * Find replacement when have {XXX} in your input
     * @param input
     * @return
     */
    private static final String regexPattern = "\\{[^\\}\\{]*\\}";
    private static final Pattern regexReplacePattern = Pattern.compile(regexPattern);
    public static String[] FindReplacement(String input)
    {
        if(!StringExtension.IsNullOrEmpty(input) && HasReplacement(input))
        {
            HashMap<String,Integer> output = new HashMap<>();
            Matcher m = regexReplacePattern.matcher(input);
            while (m.find()) {
                String item = m.group();
                String key = removeWrapper(item);
                output.put(key, 1);
            }
            if(output.size()>0)
            {
                String[] keyList = new String[output.size()];
                return output.keySet().toArray(keyList);
            }
        }
        return null;
    }
    public static boolean HasReplacement(String input){
        return input.contains("{") && input.contains("}");
    }
    private static String removeWrapper(String key){
        if(key.startsWith("{") && key.endsWith("}"))
        {
            return key.substring(1,key.length()-1);
        }
        return key;
    }

    public static String ReplaceAll(String input,String pattern,String replacement)
    {
        String replaceString = "(?i)" + Pattern.quote("{" +pattern +"}");
        //resolve regular expression \\ issue
        replacement = replacement.replace("\\","\\\\");
        return input.replaceAll(replaceString, replacement);
    }
    //endregion

}
