package LinkFuture.Init.Extensions;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 10/1/13
 * Time: 11:58 AM
 * To change this template use File | Settings | File Templates.
 */
public class MathExtension {
    public static String byteCountToDisplaySize(long bytes) {
        return byteCountToDisplaySize(bytes,true);
    }
    /***
     * byteCountToDisplaySize
     * @param bytes bytes
     * @param si true:1000 or false:1024
     * @return
     *
     *       <pre>bytes                  SI         BINARY                      </pre>
     *       <pre>0:                     0 B        0 B                         </pre>
     *       <pre>27:                    27 B       27 B                        </pre>
     *       <pre>999:                   999 B      999 B                       </pre>
     *       <pre>1000:                  1.0 kB     1000 B                      </pre>
     *       <pre>1023:                  1.0 kB     1023 B                      </pre>
     *       <pre>1024:                  1.0 kB     1.0 KiB                     </pre>
     *       <pre>1728:                  1.7 kB     1.7 KiB                     </pre>
     *       <pre>110592:                110.6 kB   108.0 KiB                   </pre>
     *       <pre>7077888:               7.1 MB     6.8 MiB                     </pre>
     *       <pre>452984832:             453.0 MB   432.0 MiB                   </pre>
     *       <pre>28991029248:           29.0 GB    27.0 GiB                    </pre>
     *       <pre>1855425871872:         1.9 TB     1.7 TiB                     </pre>
     *       <pre>9223372036854775807:   9.2 EB     8.0 EiB   (Long.MAX_VALUE)  </pre>
     *
     */
    public static String byteCountToDisplaySize(long bytes, boolean si) {
        int unit = si ? 1000 : 1024;
        if (bytes < unit) return bytes + " B";
        int exp = (int) (Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp-1) + (si ? "" : "i");
        return String.format("%.1f %sB", bytes / Math.pow(unit, exp), pre);
    }
}
