package LinkFuture.Init.Extensions;

import LinkFuture.Init.Config;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 12/18/13
 * Time: 12:13 PM
 * To change this template use File | Settings | File Templates.
 */
public class DateExtension {

    public static Date Parse(String dateString) throws ParseException {
        if(StringExtension.IsNumeric(dateString))
        {
            return new Date(Long.parseLong(dateString));
        }
        if(dateString.length()==28)
        {
            return Parse(dateString,Config.DefaultTimeFormat);
        }
        else
        {
            //if no timezone, we think it is UTC time
            DateFormat formatter = new SimpleDateFormat(Config.ISO8601TimeFormat);
            formatter.setTimeZone(Config.UTCTimeZone);
            return formatter.parse(dateString);
        }
    }
    public static Date Parse(String dateString,String format) throws ParseException {
        DateFormat formatter = new SimpleDateFormat(format);
        return formatter.parse(dateString);
    }
    public static Date UTCParse(String dateString,String format) throws ParseException {
        DateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(Config.UTCTimeZone);
        return formatter.parse(dateString);
    }
    public static String Format(Date date){
        return Format(date, Config.DefaultTimeFormat);
    }
    public static String Format(Date date,String format) {
        DateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }
    public static String UTFFormat(Date date,String format) {
        DateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(Config.UTCTimeZone);
        return formatter.format(date);
    }
    public static String UTFFormat(Date date) {
        return UTFFormat(date, Config.DefaultTimeFormat);
    }
    public static String ISO8601UTCFormat(Date date){
        return UTFFormat(date, Config.ISO8601TimeFormat);
    }
    public static Date Convert(java.sql.Timestamp timestamp)
    {
        long milliseconds = timestamp.getTime();// + (timestamp.getNanos() / 1000000);
        return new java.util.Date(milliseconds);
    }
}
