package LinkFuture.Core.WebClient;

import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.NameValuePair;


import javax.xml.bind.DatatypeConverter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * User: Cyokin Zhang
 * Date: 11/18/13
 * Time: 4:57 PM
 */
public class WebRequestInfo {
    public WebRequestInfo(){
        this.RequestHeadList = new HashMap<>();
        this.PostFileList = new HashMap<>();
        this.PostStringList = new HashMap<>();
        this.addHead("User-Agent","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/6.0; LinkFuture.Core)");
        this.addHead("Accept-Encoding","gzip");
        this.addHead("Accept-Charset", Config.DefaultEncoding);
        this.addHead("Accept","text/html, application/xhtml+xml, */*");
        this.UseCaches = true;
        this.AutoRedirect = true;
    }
    public URL RequestURL;
    //public String PostData;
    public HttpMethod RequestMethod = HttpMethod.Get;
    public HashMap<String,Object> RequestHeadList;
    public HashMap<String,WebRequestFileInfo> PostFileList;
    public HashMap<String,Object> PostStringList;

    public int ConnectionTimeout;
    public int ReadTimeout;
    public boolean UseCaches;
    public boolean AutoRedirect;
    public FormContentTypes EncType = FormContentTypes.UrlEncoded;
    public String Payload;
    public CredentialInfo Credential;

    /**
     * addPostData,by default use Form application/x-www-form-urlencoded if you don't have file
     * You can't have both Payload and PostData.
     */
    public void addPostData(String name,Object value) throws UnsupportedEncodingException {
        this.PostStringList.put(name,value);
    }
    /**
     * addPostFile,we will use multipart/form-data
     */
    public void addPostFile(WebRequestFileInfo file) {
        this.PostFileList.put(file.Name, file);
    }

    public void addHead(String name,Object value)
    {
        this.RequestHeadList.put(name,value);
    }
    /**
     * addPayload, you must addHead("Content-Type","XXX")
     * You can't have both Payload and PostData.
     */
    public void addPayload(String payload)
    {
        this.Payload = payload;
    }
}
