package LinkFuture.Core;

import LinkFuture.Init.Debugger;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by Cyokin
 * on 3/23/2015.
 */
public class Singleton {
    private final static ConcurrentHashMap map = new ConcurrentHashMap();

    public static synchronized<T> T getInstance(Class<T> myClass,Object ... params) throws Exception {
        String className = myClass.getName();
        return getInstance(className,params);
    }
    @SuppressWarnings("unchecked")
    public static synchronized<T> T getInstance(String className,Object ... params) throws Exception {
        if(map.containsKey(className))
        {
            return (T)map.get(className);
        }
        Debugger.LogFactory.info("Generating singleton class {}",className);
        T instance =  ActivatorsStorage.GetActivator(className,params);
        map.put(className,instance);
        return instance;
    }
}
