package LinkFuture.Core.MemoryManager.Meta;

import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.TimeSpan;
import LinkFuture.Core.OperationManager.Operation;


/**
 * User: Cyokin Zhang
 * Date: 10/12/13
 * Time: 2:19 PM
 */
public class MemoryMetaInfo extends MemorySettingInfo {
    public String Key;
    public Operation Action;
    private String uniqueKey;
    public String getUniqueKey(){
        if(StringExtension.IsNullOrEmpty(this.uniqueKey)){
            this.uniqueKey = "$LinkFuture.MemoryFactory$_".concat(this.Key);
        }
        return this.uniqueKey;
    }
    public TimeSpan getTimeSpan(){
        return TimeSpan.FromMin(this.Duration);
    }
    public static MemoryMetaInfo build(MemorySettingInfo setting){
        MemoryMetaInfo metaInfo = new MemoryMetaInfo();
        metaInfo.AutoRefresh = setting.AutoRefresh;
        metaInfo.CacheSettingName = setting.CacheSettingName;
        metaInfo.Enable = setting.Enable;
        metaInfo.CacheType = setting.CacheType;
        metaInfo.Duration = setting.Duration;
        metaInfo.CacheSource = setting.CacheSource;
        return metaInfo;
    }
}
