package LinkFuture.Core.MemoryManager.Meta;

import LinkFuture.Core.Utility;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.IOException;

/**
 * Created by Cyokin
 * on 10/2/2016.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class MemoryInfo<T> {
    public T cachedObject;
    public long expiredTime;
    public long cachedTime;
    public MemoryMetaInfo meta;

    public boolean hasExpired(){
        return this.expiredTime <= System.currentTimeMillis();
    }

    @Override
    public String toString() {
        try {
            return Utility.jacksonToJson(this);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
