package LinkFuture.Core.JsonManager;

import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.JAXBCaseInsensitiveMapAdaptor;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.HashSet;


/**
 * User: Cyokin Zhang
 * Date: 10/23/13
 * Time: 12:19 PM
 */
@XmlRootElement(name="JsonOption")
@XmlSeeAlso(JsonValueXPathInfo.class)
public class JsonOptionInfo {
    @XmlAttribute(name="AttributePrefix")
    public String AttributePrefix = "@";
    /**
     * prefix xmlns:namespaces
     * xmlns:dc="http://purl.org/dc/elements/1.1/"
     */
    @XmlAttribute(name="NamespacePrefix")
    public String NamespacePrefix= "xmlns:";


    @XmlAttribute(name="CDataNodeName")
    public String CDataNodeName = "$";
    /**
     * Default is true
     * ignore Namespace name before node,
     * i.e dc:nodeName => nodeName
     */
    @XmlAttribute(name="IgnoreNamespace")
    public boolean IgnoreNamespace = true;

    @XmlElementWrapper(name="ForceArrayXPath")
    @XmlElement(name="Item")
    public HashSet<String> ForceArrayXPathList;

    @XmlAttribute(name="AllArray")
    public boolean AllArray = false;

    @XmlAttribute(name="JsonValueOption")
    public JsonValueOption ValueOption = JsonValueOption.AllString;

    @XmlElement(name="ForceValueTypeList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<JsonValueXPathInfo> ForceValueTypeList;

    @XmlAttribute(name="AutoNull")
    public boolean AutoNull = false;

    @XmlAttribute(name="IgnoreRoot")
    public boolean IgnoreRoot = false;
}
