package LinkFuture.Core.JsonManager;


import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;
import com.sun.org.apache.xerces.internal.impl.XMLStreamReaderImpl;
import org.xml.sax.SAXException;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import java.io.*;
import java.util.ArrayList;

/**
 * User: Cyokin Zhang
 * Date: 10/23/13
 * Time: 12:19 PM
 */
public class JsonObjectReader implements AutoCloseable {
    XMLStreamReader streamReader;
    public JsonObjectReader(String xmlString) throws ParserConfigurationException, IOException, SAXException, XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        InputStream in = new ByteArrayInputStream(xmlString.getBytes(Config.DefaultEncoding));
        streamReader = inputFactory.createXMLStreamReader(in);
    }
    public JsonObjectInfo toJsonObj() throws XMLStreamException {
        JsonObjectInfo rootObj = new JsonObjectInfo();
        rootObj.XPath = "";
        //JsonObjectInfo parentObj = rootObj;
        if (streamReader.hasNext())
        {
            parseToJson(rootObj);
            return rootObj.ChildNodes.get(0);
        }
        return null;
    }
    private String getNodeName(QName name)  {
        if(StringExtension.IsNullOrEmpty(name.getPrefix()))
        {
            return name.getLocalPart();
        }
        else {
            return name.getPrefix() + ":" + name.getLocalPart();
        }
    }
    private void parseToJson(JsonObjectInfo parentObj) throws XMLStreamException {
        boolean hasNext = true;
        while (hasNext)
        {
            int current = streamReader.getEventType();
            String CHARACTERS = null;
            switch (current)
            {
                case XMLStreamReader.START_ELEMENT:
                    JsonObjectInfo newObj = new JsonObjectInfo();
                    newObj.Name = this.getNodeName(streamReader.getName());
                    newObj.XPath = parentObj.XPath + "/" + newObj.Name;
                    newObj.Parent = parentObj;
                    newObj.Type = JsonObjectType.Element;
                    //append attribute
                    if(streamReader.getAttributeCount() >0)
                    {
                        newObj.ChildNodes = new ArrayList<>();
                        for(int i=0;i<streamReader.getAttributeCount();i++)
                        {
                            JsonObjectInfo attr = new JsonObjectInfo();
                            attr.Type = JsonObjectType.Attribute;
                            if(streamReader.getAttributeNamespace(i)==null)
                            {
                                attr.Name = streamReader.getAttributeLocalName(i);
                            }
                            else
                            {
                                attr.Name =streamReader.getAttributePrefix(i) + ":" +streamReader.getAttributeLocalName(i);
                            }
                            attr.XPath = newObj.XPath + "/@" +  attr.Name;
                            attr.Value = streamReader.getAttributeValue(i);
                            attr.Parent = newObj;
                            //ignore <number i:nil="true"></number> node, .NET DataContract issue
                            if(attr.Name.equalsIgnoreCase("i:nil") && attr.Value.equalsIgnoreCase("true"))
                            {
                                continue;
                            }
                            newObj.ChildNodes.add(attr);
                        }
                    }
                    //append Namespace
                    if(streamReader.getNamespaceCount() >0)
                    {
                        if(newObj.ChildNodes==null)
                        {
                            newObj.ChildNodes = new ArrayList<>();
                        }
                        for(int i=0;i<streamReader.getNamespaceCount();i++)
                        {
                            JsonObjectInfo attr = new JsonObjectInfo();
                            attr.Name = streamReader.getNamespacePrefix(i);
                            attr.XPath = newObj.XPath + "/@" +  attr.Name;
                            attr.Value = streamReader.getNamespaceURI(i);
                            attr.Parent = newObj;
                            attr.Type = JsonObjectType.Namespace;
                            newObj.ChildNodes.add(attr);
                        }
                    }
                    if(parentObj.ChildNodes==null)
                    {
                        parentObj.ChildNodes = new ArrayList<>();
                    }
                    parentObj.ChildNodes.add(newObj);
                    parentObj =  newObj;
                    break;
                case XMLStreamReader.END_ELEMENT:
                    //move up
                    parentObj = parentObj.Parent;
                    break;
//            case XMLStreamReader.CHARACTERS:
//                if(((XMLStreamReaderImpl)streamReader).hasValue())
//                {
//                    CHARACTERS = ((XMLStreamReaderImpl)streamReader).getValue().trim();
//                }
            }
            if(streamReader.hasNext())
            {
                //append if CDATA
                while (streamReader.next()==XMLStreamReader.CHARACTERS)
                {
                    if(((XMLStreamReaderImpl)streamReader).hasValue())
                    {
                        String tmp = ((XMLStreamReaderImpl)streamReader).getValue().trim();
                        if(!StringExtension.IsNullOrEmpty(tmp))
                        {
                            if(CHARACTERS==null)
                            {
                                CHARACTERS = tmp;
                            }
                            else {
                                CHARACTERS += tmp;
                            }
                        }
                    }
                }
                if(!StringExtension.IsNullOrEmpty(CHARACTERS) && streamReader.getEventType()==XMLStreamReader.END_ELEMENT)
                {
                    if(parentObj.ChildNodes==null)
                    {
                        parentObj.Value = CHARACTERS;
                    }
                    else
                    {
                        //handle  <guid isPermaLink="false">http://cyokin.wordpress.com/?p=360</guid>
                        JsonObjectInfo cDataObj = new JsonObjectInfo();
                        cDataObj.Name ="$";
                        cDataObj.XPath = parentObj.XPath + "/text()";
                        cDataObj.Value = CHARACTERS;
                        cDataObj.Parent = parentObj;
                        cDataObj.Type = JsonObjectType.CDATA;
                        parentObj.ChildNodes.add(cDataObj);
                    }
                }
                //move to next elements
                //parseToJson(parentObj);
            }
            else
            {
                hasNext = false;
            }
        }
    }
    @Override
    public void close() throws Exception {
        if(streamReader!=null)
        {
            streamReader.close();
            streamReader = null;
        }
    }
}
