package LinkFuture.Core.GenericRepository.Entity.Operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by Cyokin
 * on 8/24/2016.
 */
public class OperationBuilder<T extends OperationBuilder<T>> {
    Class<?> operationType;
    public OperationBuilder(Class<? extends OperationBase> type)
    {
        this.operationType = type;
    }
    private List<Object> queryMaps = new ArrayList<>();
    public T add(Number... numbers) {
        this.queryMaps.addAll(Arrays.asList(numbers));
        return (T) this;
    }
    public T add(String... fields) {
        this.queryMaps.addAll(Arrays.asList(fields));
        return (T) this;
    }
    public T add(OperationBase... operationBases) {
        this.queryMaps.addAll(Arrays.asList(operationBases));
        return (T) this;
    }
    public OperationBase build() throws IllegalAccessException, InstantiationException {
        OperationBase output = (OperationBase) operationType.newInstance();
        if (this.queryMaps.size() < 2) {
            throw new IllegalArgumentException("You must have two number for " + output.getOperation());
        }
        output.put(output.getOperation(),this.queryMaps);
        return output;
    }
}
