package LinkFuture.Core.GenericRepository.Entity;

import LinkFuture.Core.DBHelper.GenericDBHelper;

import java.util.*;

/**
 * Created by Cyokin
 * on 10/25/2015.
 */
public class GenericWhere extends LinkedHashMap<String,Object> {
    private Builder builder;
    public Builder getBuilder(){
        return this.builder;
    }
    public static class Builder<T extends Builder<T>> {
        private HashMap<String,Object> whereMaps = new HashMap<>();
        private List<GenericWhere> orList = new ArrayList<>();
        public T and(String key,Object value){
            this.whereMaps.put(key, value);
            return (T)this;
        }
        public T or(GenericWhere where){
            orList.add(where);
            return (T)this;
        }
        public T gt(String key, final Number value){
            this.whereMaps.put(key, new HashMap<String, Number>() {{
                put(GenericDBHelper.$GT, value);
            }});
            return (T)this;
        }
        public T gte(String key, final Number value){
            this.whereMaps.put(key, new HashMap<String, Number>() {{
                put(GenericDBHelper.$GTE, value);
            }});
            return (T)this;
        }
        public T lt(String key, final Number value){
            this.whereMaps.put(key, new HashMap<String, Number>() {{
                put(GenericDBHelper.$LT, value);
            }});
            return (T)this;
        }
        public T lte(String key, final Number value){
            this.whereMaps.put(key, new HashMap<String, Number>() {{
                put(GenericDBHelper.$LTE, value);
            }});
            return (T)this;
        }
        public T in(String key, final Object... values){
            this.whereMaps.put(key, new HashMap<String, Object[]>() {{
                put(GenericDBHelper.$IN, values);
            }});
            return (T)this;
        }
        public T like(String key, final String like){
            this.whereMaps.put(key, new HashMap<String, String>() {{
                put(GenericDBHelper.$LIKE, like);
            }});
            return (T)this;
        }
        public T between(String key, final String start,final String end){
            this.whereMaps.put(key, new HashMap<String, Object>() {{
                put(GenericDBHelper.$BETWEEN, Arrays.asList(start,end));
            }});
            return (T)this;
        }
        public T similar(String key, final String similar){
            this.whereMaps.put(key, new HashMap<String, String>() {{
                put(GenericDBHelper.$SIMILAR, similar);
            }});
            return (T)this;
        }
        public GenericWhere build() {
            if(orList.size()>0)
            {
                this.whereMaps.put(GenericDBHelper.$OR, orList);
            }
            GenericWhere whereInfo=new GenericWhere();
            whereInfo.builder = this;
            whereInfo.putAll(this.whereMaps);
            return whereInfo;
        }
    }
    public static Builder<?> builder(){
        return new Builder();
    }
}
