package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Init.Extensions.StringExtension;

import java.sql.Types;

/**
 * Created by Cyokin
 * on 7/28/2016.
 */
public class GenericWhereQueryInfo {
    private ColumnInfo column;
    private String subQuery;
    private String uniqueName;
    private String columnName;
    private ColumnInfo valueColumn;

    public ColumnInfo getValueColumn() {
        return this.valueColumn;
    }

    public ColumnInfo getColumn() {
        return column;
    }

    public String getColumnName() {
        return columnName;
    }

    public String getSubQuery() {
        return subQuery;
    }

    public String getUniqueName() {
        return uniqueName;
    }

    public GenericWhereQueryInfo(ColumnInfo column, String subQuery,String uniqueName) {

        this.column = column;
        this.subQuery = subQuery;
        this.uniqueName = uniqueName;
        boolean isStructSubQuery = column.sqlType == Types.STRUCT && !StringExtension.IsNullOrEmpty(subQuery);
        this.columnName = isStructSubQuery ? String.format("(%s).%s", column.columnName, subQuery) : column.columnName;
        this.valueColumn = isStructSubQuery ? column.getStructElementColumn(subQuery) : column;
    }
}
