package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Core.Utility;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.JAXBCData;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * LinkFuture.
 * User: Cyokin Zhang
 * Date: 11/2/13
 * Time: 4:22 PM
 */
public class MetaBaseInfo {

    @XmlAttribute(name = "Type")
    public String Type;

    @XmlJavaTypeAdapter(value = JAXBCData.class)
    @XmlValue
    public String Meta;

    @XmlTransient
    private Object metaObj;

    public<T> T getMetaObj(){
        return (T)metaObj;
    }
    public<T> void setMetaObj(Class<T> type){
        if(metaObj==null && !StringExtension.IsNullOrEmpty(this.Meta))
        {
            metaObj = Utility.fromXml(this.Meta, type);
        }
    }
}
