package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.RawSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.json.JSONObject;

import java.io.IOException;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 12/4/13
 * Time: 11:44 AM
 * To change this template use File | Settings | File Templates.
 */
public class ContentResultInfo {
    public String Name;
    public Exception Error;
    @JsonSerialize(using =ResultJsonSerializer.class)
    @JsonDeserialize(using = ResultJsonDeserializer.class)
    public Object Result;
    public boolean Success;
    public String Meta;
    public ContentResultType ResultType;
    public int ErrorCode;
    public long LoadTimeInMs;
    public long CachedTime;
    public long ExpiredTime;

    @JsonIgnore
    public ResourceInfo Resource;
    @JsonIgnore
    public AddInfo Add;

    @Override
    public String toString() {
        return this.Result==null? Config.Empty:this.Result.toString();
    }
    public static class ResultJsonSerializer extends StdSerializer<Object> {
        public ResultJsonSerializer() {
            this(null);
        }
        protected ResultJsonSerializer(Class<Object> t) {
            super(t);
        }
        private RawSerializer<String> rawSerializer = new RawSerializer<String>(String.class);
        private ToStringSerializer stringSerializer = ToStringSerializer.instance;
        @Override
        public void serialize(Object o, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {

            if(o instanceof JSONObject)
            {
                rawSerializer.serialize(o.toString(), jgen, serializerProvider);
            }
            else
            {
                stringSerializer.serialize(o, jgen, serializerProvider);
            }
        }
    }
    public static class ResultJsonDeserializer extends StdDeserializer<Object>{
        public ResultJsonDeserializer() {
            this(null);
        }
        protected ResultJsonDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String result = jsonParser.readValueAsTree().toString();
            if(result.startsWith("{") && result.endsWith("}"))
            {
                return new JSONObject(result);
            }
            else
            {
                return StringExtension.JsonDeQuote(result);
            }
        }
    }
}
