package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Core.ContentManager.ContentSelector.ContentSelectorMeta;
import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;

import java.util.Map;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */

public class ContentParameterCollectionInfo extends CaseInsensitiveMap<Object>{
    public String ParamReplace(String input)
    {
        String[] list = StringExtension.FindReplacement(input);
        if(list!=null)
        {
            for (int i=0;i<list.length;i++)
            {
                String key = list[i];
                if(this.containsKey(key))
                {
                    String replacement = this.get(key).toString();
                    input = StringExtension.ReplaceAll(input,key,replacement);
                }
            }
        }
        return input;
    }
    public Object getSelector(String key) throws Exception {
        if(ContentSelectorMeta.IsContentSelectorMeta(key))
        {
            ContentSelectorMeta meta = ContentSelectorMeta.Parser(key);
            return meta.GetSelector(this).Selector();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for(Map.Entry<String,Object> item: this.entrySet())
        {
            sb.append(item.getKey());
            sb.append("=>");
            sb.append(item.getValue());
            sb.append(Config.NewLine);
        }
        return sb.toString();
    }
}
